/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.ui.controls;

import com.jniwrapper.win32.ui.dialogs.SelectIconDialog;
import com.jniwrapper.win32.shell.ShellIcon;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.LastErrorException;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;

/**
 * ChooseIconField class is a component for selecting icon that uses
 * SelectIconDialog.
 *
 * @author Vladimir Kondrashchenko
 */
public class ChooseIconField extends AbstractChooserField
{
    public static final String PROPERTY_ICON = "icon";

    private JLabel image;
    private SelectIconDialog _dialog;
    
    protected JComponent createField()
    {
        image = new JLabel();
        Dimension size = new Dimension(36, 38);
        image.setPreferredSize(size);
        image.setMinimumSize(size);
        image.setMaximumSize(size);
        image.setBackground(Color.WHITE);
        image.addMouseListener(new MouseAdapter()
        {
            public void mouseClicked(MouseEvent e)
            {
                //handle double click mouse event
                if (e.getClickCount() == 2)
                {
                    actionPerformed(null);
                }
            }
        });

        JPanel bevel = new JPanel();
        bevel.setBackground(Color.WHITE);
        bevel.setBorder(BorderFactory.createEtchedBorder());
        bevel.setLayout(new GridBagLayout());
        bevel.add(image, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

        JButton selectButton = getSelectButton();
        selectButton.setBorder(BorderFactory.createEtchedBorder());
        selectButton.setPreferredSize(new Dimension(20, 38));

        return bevel;
    }

    public ChooseIconField()
    {
        super();
    }

    public ChooseIconField(File iconFile)
    {
        this();
        if (iconFile.exists())
        {
            setIconImage(new ShellIcon(iconFile));
            setIconFile(iconFile);
        }
    }

    public ChooseIconField(File iconFile, int iconIndex)
    {
        this();
        if (iconFile.exists())
        {
            setIconImage(new ShellIcon(iconFile, iconIndex));
            setIconFile(iconFile);
            setIconIndex(iconIndex);
        }
    }

    public void actionPerformed(ActionEvent e)
    {
        SelectIconDialog dialog = getDialog();
        if (dialog.getOwner() == null)
            dialog.setOwner(SwingUtilities.getWindowAncestor(this));
        String oldIcon = dialog.getIconFile().getAbsolutePath()+Integer.toString(dialog.getIconIndex());
        if (dialog.execute())
        {
            setIconImage(dialog.getShellIcon());
            String newIcon = dialog.getIconFile().getAbsolutePath()+Integer.toString(dialog.getIconIndex());
            firePropertyChange(PROPERTY_ICON, oldIcon, newIcon);
        }
    }

    private void setIconImage(ShellIcon shellIcon)
    {
        try
        {
            final Icon icon = shellIcon;
            final ImageIcon imageIcon = new ImageIcon(icon.toImage());
            image.setIcon(imageIcon);
        }
        catch (LastErrorException ex)
        {

        }
    }

    public void setIconImage(File iconFile, int iconIndex)
    {
        setIconFile(iconFile);
        setIconIndex(iconIndex);
        setIconImage(getShellIcon());
    }

    /**
     * Returns ChooseIconDialog.
     *
     * @return dialog instance.
     */
    public SelectIconDialog getDialog()
    {
        if (_dialog == null)
        {
            _dialog = new SelectIconDialog();
        }
        return _dialog;
    }

    public void setIconFile(File value)
    {
        getDialog().setIconFile(value);
    }

    public File getIconFile()
    {
        return getDialog().getIconFile();
    }

    public void setIconIndex(int value)
    {
        getDialog().setIconIndex(value);
    }

    public int getIconIndex()
    {
        return getDialog().getIconIndex();
    }

    public ShellIcon getShellIcon()
    {
        return getDialog().getShellIcon();
    }
}