/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.ui.controls;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * This class represents combined megawidget which contains
 * text field and button.
 *
 * @author Serge Piletsky
 */
public class AbstractChooserField extends JPanel implements ActionListener
{
    private JComponent _field;
    private JButton _selectButton = new JButton("...");

    public AbstractChooserField()
    {
        _selectButton.setPreferredSize(new Dimension(20, 20));
        _selectButton.addActionListener(this);

        setLayout(new GridBagLayout());
        add(getField(), new GridBagConstraints(0, 0, 1, 1, 2.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 3), 0, 0));
        add(_selectButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JComponent createField()
    {
        JComponent result = new JTextField();
        Dimension preferredSize = new Dimension(150, 20);
        result.setPreferredSize(preferredSize);
        result.setMinimumSize(preferredSize);
        return result;
    }

    public JComponent getField()
    {
        if (_field == null)
        {
            _field = createField();
        }
        return _field;
    }

    public JTextField getTextField()
    {
        return (JTextField) getField();
    }

    public JButton getSelectButton()
    {
        return _selectButton;
    }

    public void setEnabled(boolean enabled)
    {
        _field.setEnabled(enabled);
        _selectButton.setEnabled(enabled);
    }

    public void actionPerformed(ActionEvent e)
    {
    }
}