package com.jniwrapper.win32.ui;

import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt;
import com.jniwrapper.win32.Point;
import com.jniwrapper.win32.Rect;

/**
 * Wrapper for <code>WINDOWPLACEMENT<code/> structure.
 */
public class WindowPlacement extends Structure
{
    private UInt length = new UInt();
    private UInt flags = new UInt();
    private UInt showCmd = new UInt();
    private Point ptMinPosition = new Point();
    private Point ptMaxPosition = new Point();
    private Rect ptNormalPosition = new Rect();

    public WindowPlacement()
    {
        init();
    }

    private void init()
    {
        init(new Parameter[]{
                length,
                flags,
                showCmd,
                ptMinPosition,
                ptMaxPosition,
                ptNormalPosition
        }, (short) 8);
        length.setValue(getLength());
    }

    public WindowPlacement(long flags, long showCmd, Point ptMinPosition, Point ptMaxPosition, Rect ptNormalPosition)
    {
        this.flags.setValue(flags);
        this.showCmd.setValue(showCmd);
        this.ptMinPosition = ptMinPosition;
        this.ptMaxPosition = ptMaxPosition;
        this.ptNormalPosition = ptNormalPosition;
        init();
    }

    public UInt getFlags()
    {
        return flags;
    }

    public UInt getShowCmd()
    {
        return showCmd;
    }

    public Point getMinPosition()
    {
        return ptMinPosition;
    }

    public Point getMaxPosition()
    {
        return ptMaxPosition;
    }

    public Rect getNormalPosition()
    {
        return ptNormalPosition;
    }
}
