package com.jniwrapper.win32.ui;

import com.jniwrapper.*;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.Rect;

/**
 * This class represents <code>GUITHREADINFO</code> structure.
 *
 * @author Serge Piletsky
 */
public class GUIThreadInfo extends Structure
{
    public static final int GUI_CARETBLINKING = 0x00000001;
    public static final int GUI_INMOVESIZE = 0x00000002;
    public static final int GUI_INMENUMODE = 0x00000004;
    public static final int GUI_SYSTEMMENUMODE = 0x00000008;
    public static final int GUI_POPUPMENUMODE = 0x00000010;
    public static final int GUI_16BITTASK = 0x00000020;

    private UInt32 cbSize = new UInt32();
    private UInt32 flags = new UInt32();
    private Wnd hwndActive = new Wnd();
    private Wnd hwndFocus = new Wnd();
    private Wnd hwndCapture = new Wnd();
    private Wnd hwndMenuOwner = new Wnd();
    private Wnd hwndMoveSize = new Wnd();
    private Wnd hwndCaret = new Wnd();
    private Rect rcCaret = new Rect();

    public GUIThreadInfo()
    {
        init(new Parameter[]{
                cbSize,
                flags,
                hwndActive,
                hwndFocus,
                hwndCapture,
                hwndMenuOwner,
                hwndMoveSize,
                hwndCaret,
                rcCaret
        });
        cbSize.setValue(getLength());
    }

    public UInt32 getCbSize()
    {
        return cbSize;
    }

    public UInt32 getFlags()
    {
        return flags;
    }

    public Wnd getHwndActive()
    {
        return hwndActive;
    }

    public Wnd getHwndFocus()
    {
        return hwndFocus;
    }

    public Wnd getHwndCapture()
    {
        return hwndCapture;
    }

    public Wnd getHwndMenuOwner()
    {
        return hwndMenuOwner;
    }

    public Wnd getHwndMoveSize()
    {
        return hwndMoveSize;
    }

    public Wnd getHwndCaret()
    {
        return hwndCaret;
    }

    public Rect getRcCaret()
    {
        return rcCaret;
    }

    /**
     * Retrieves information about the active window or a specified graphical user interface (GUI) thread.
     *
     * @param threadID Identifies the thread for which information is to be retrieved.
     * @return information describing the thread.
     */
    public static GUIThreadInfo getGUIThreadInfo(long threadID)
    {
        Function getGUIThreadInfo = User32.getInstance().getFunction("GetGUIThreadInfo");
        Bool result = new Bool();
        GUIThreadInfo resultValue = new GUIThreadInfo();
        long errorCode = getGUIThreadInfo.invoke(result, new UInt32(threadID), new Pointer(resultValue));
        if (!result.getValue())
        {
            throw new LastErrorException(errorCode);
        }
        return resultValue;
    }
}
