/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.*;
import com.jniwrapper.win32.Handle;

/**
 * PROCESS_HEAP_ENTRY structure
 */
public class ProcessHeapEntry extends Structure
{
    public Pointer.Void _lpData = new Pointer.Void(); // PVOID
    public UInt32 _cbData = new UInt32(); // DWORD
    public UInt8 _cbOverhead = new UInt8(); // BYTE
    public UInt8 _iRegionIndex = new UInt8(); // BYTE
    public UInt16 _wFlags = new UInt16(); // WORD
    public InnerUnion _innerUnion = new InnerUnion(); // Inner union

    static public int PROCESS_HEAP_ENTRY_BUSY = 0x0004; // The heap element is an allocated block.
    static public int PROCESS_HEAP_ENTRY_DDESHARE = 0x0020; // This value must be used with PROCESS_HEAP_ENTRY_BUSY, indicating that the heap element is an allocated block.
    static public int PROCESS_HEAP_ENTRY_MOVEABLE = 0x0010; // This value must be used with PROCESS_HEAP_ENTRY_BUSY, indicating that the heap element is an allocated block.
    static public int PROCESS_HEAP_REGION = 0x0001; // The heap element is located at the beginning of a region of contiguous virtual memory in use by the heap. 
    static public int PROCESS_HEAP_UNCOMMITTED_RANGE = 0x0002; // The heap element is located in a range of uncommitted memory within the heap region.

    public static class Block extends Structure
    {
        Handle _hMem = new Handle(); // HANDLE
        UInt32 _dwReserved1 = new UInt32(); // DWORD[3]
        UInt32 _dwReserved2 = new UInt32(); // DWORD[3]
        UInt32 _dwReserved3 = new UInt32(); // DWORD[3]

        public Block()
        {
            super.init(new Parameter[]
                    {_hMem, _dwReserved1, _dwReserved2, _dwReserved3});
        }
    }

    public static class Region extends Structure
    {
        UInt32 _dwCommittedSize = new UInt32(); // DWORD
        UInt32 _dwUnCommittedSize = new UInt32(); // DWORD
        Pointer.Void _lpFirstBlock = new Pointer.Void(); // LPVOID
        Pointer.Void _lpLastBlock = new Pointer.Void(); // LPVOID

        public Region()
        {
            super.init(new Parameter[]
                    {_dwCommittedSize, _dwUnCommittedSize, _lpFirstBlock, _lpLastBlock});
        }
    }

    public static class InnerUnion extends Union
    {
        Block _block = new Block();
        Region _region = new Region();

        public InnerUnion()
        {
            super.init(new Parameter[] {_block, _region});
        }
    }

    public ProcessHeapEntry()
    {
        super.init(new Parameter[]
                { _lpData, _cbData, _cbOverhead, _iRegionIndex, _wFlags, _innerUnion });
    }

    
}