/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.system;

/**
 * Class EnvironmentVariables.
 */
public interface EnvironmentVariables
{
    /**
     * Returns the value of the specified variable 
     *
     * @param variable The name of the variable.
     * @return a value for the variable.
     */
    String getValue(String variable);

    /**
     * Sets the value of the specified variable.
     *
     * @param variable The name of the variable.
     * @param value The value of the variable.
     */
    void setValue(String variable, String value);

    /**
     * Removes specified variable.
     *
     * @param variable The name of the variable.
     */
    void removeVariable(String variable);

    /**
     * Verifies if there is a specified variable in the environment.
     *
     * @param variable The name of the variable.
     * @return TRUE, if the specified variable exists in the environment;
     * otherwise FALSE.
     */
    boolean contains(String variable);

 /**
     * Returns an array of the variable names.
     *
     * @return An array of the variable names.
     */
    String[] getVariableNames();
}