/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.shell;

import com.jniwrapper.*;

/**
 * Represents <code>COMPPOS</code> native structure, which
 * holds information about position and size of the component
 */
public class ComponentLocation extends Structure
{
    private UInt32 dwSize = new UInt32();
    private Int iLeft = new Int();
    private Int iTop = new Int();
    private UInt32 dwWidth = new UInt32();
    private UInt32 dwHeight = new UInt32();
    private Int izIndex = new Int();
    private IntBool fCanResize = new IntBool();
    private IntBool fCanResizeX = new IntBool();
    private IntBool fCanResizeY = new IntBool();
    private Int iPreferredLeftPercent = new Int();
    private Int iPreferredTopPercent = new Int();

    /**
     * Creates an instance of ComponentLocation class
     */
    public ComponentLocation()
    {
        init(new Parameter[]{dwSize, iLeft, iTop, dwWidth, dwHeight, izIndex, fCanResize, fCanResizeX, fCanResizeY, iPreferredLeftPercent, iPreferredTopPercent});
        dwSize.setValue(getLength());
    }

    /**
    * Creates an instance of ActiveDesktopItem with a specified item.
    *
    * @param that Instance of the ComponentLocation class  
    */
    public ComponentLocation(ComponentLocation that)
    {
        this();
        initFrom(that);
    }

    /**
    *  Initializes this structure with values from another instance of the ComponentLocation class
    *
    * @param that Instance of the ComponentLocation class
    */
    void copyFrom(ComponentLocation that)
    {
        dwSize.setValue(that.dwSize.getValue());
        iLeft.setValue(that.iLeft.getValue());
        iTop.setValue(that.iTop.getValue());
        dwWidth.setValue(that.dwWidth.getValue());
        dwHeight.setValue(that.dwHeight.getValue());
        izIndex.setValue(that.izIndex.getValue());
        fCanResize.setValue(that.fCanResize.getValue());
        fCanResizeX.setValue(that.fCanResizeX.getValue());
        fCanResizeY.setValue(that.fCanResizeY.getValue());
        iPreferredLeftPercent.setValue(that.iPreferredLeftPercent.getValue());
        iPreferredTopPercent.setValue(that.iPreferredTopPercent.getValue());
    }

    /**
     * Returns left edge of the top-left corner in screen coordinates.
     *
     * @return The left edge of the top-left corner in screen coordinates.
     */
    public int getLeft()
    {
        return (int)iLeft.getValue();
    }

    /**
     * Sets left edge of the top-left corner in screen coordinates.
     *
     * @param left The left edge of the top-left corner in screen coordinates.
     */
    public void setiLeft(int left)
    {
        iLeft.setValue(left);
    }

    /**
     * Returns top of the top-left corner in screen coordinates.
     *
     * @return The top of the top-left corner in screen coordinates.
     */
    public int getTop()
    {
        return (int)iTop.getValue();
    }

    /**
     * Sets top of the top-left corner in screen coordinates.
     *
     * @param top The top of the top-left corner in screen coordinates.
     */
    public void setTop(int top)
    {
        iTop.setValue(top);
    }

    /**
     * Returns width, in pixels
     *
     * @return The width, in pixels
     */
    public int getWidth()
    {
        return (int)dwWidth.getValue();
    }

    /**
     * Sets width, in pixels
     *
     * @param width The width, in pixels
     */
    public void setWidth(int width)
    {
        dwWidth.setValue(width);
    }

    /**
     * Returns height, in pixels
     *
     * @return The height, in pixels
     */
    public int getHeight()
    {
        return (int)dwHeight.getValue();
    }

    /**
     * Sets height, in pixels
     *
     * @param height The height, in pixels
     */
    public void setHeight(int height)
    {
        dwHeight.setValue(height);
    }

    /**
     * Returns z-order of the component.
     *
     * @return The z-order of the component.
     */
    public int getIndex()
    {
        return (int)izIndex.getValue();
    }

    /**
     * Sets z-order of the component.
     *
     * @param index The z-order of the component.
     */
    public void setIndex(int index)
    {
        izIndex.setValue(index);
    }

    /**
     * Returns value, which indicates whether the component is resizable or not
     * 
     * @return TRUE if the component is resizable, FALSE if not
     */
    public boolean getCanResize()
    {
        return fCanResize.getBooleanValue();
    }

    /**
     * Sets the value of the property, which indicates whether the component is resizable or not
     *
      * @param canResize TRUE if the component is resizable, FALSE if not
     */
    public void setCanResize(boolean canResize)
    {
        fCanResize.setBooleanValue(canResize);
    }

    /**
     *  Returns value, which indicates whether the component is resizable in the x-direction or not
     *
     * @return TRUE if the component is resizable in the x-direction, FALSE if not
     */
    public boolean getCanResizeX()
    {
        return fCanResizeX.getBooleanValue();
    }

    /**
     * Sets the value of the property, which indicates whether the component is resizable in the x-direction or not
     *
      * @param canResizeX TRUE if the component is resizable in the x-direction, FALSE if not
     */
    public void setCanResizeX(boolean canResizeX)
    {
        fCanResizeX.setBooleanValue(canResizeX);
    }

    /**
     *  Returns value, which indicates whether the component is resizable in the y-direction or not
     *
     * @return TRUE if the component is resizable in the y-direction, FALSE if not
     */
    public boolean getCanResizeY()
    {
        return fCanResizeY.getBooleanValue();
    }

    /**
     * Sets the value of the property, which indicates whether the component is resizable in the y-direction or not
     *
      * @param canResizeY TRUE if the component is resizable in the y-direction, FALSE if not
     */
    public void setCanResizeY(boolean canResizeY)
    {
        fCanResizeY.setBooleanValue(canResizeY);
    }

    /**
     * Returns left edge of the upper-left corner as a percentage of screen width
     *
     * @return The left edge of the upper-left corner as a percentage of screen width
     */
    public int getPreferredLeftPercent()
    {
        return (int)iPreferredLeftPercent.getValue();
    }

    /**
     * Sets left edge of the upper-left corner as a percentage of screen width
     *
     * @param preferredLeftPercent The left edge of the upper-left corner as a percentage of screen width
     */
    public void setPreferredLeftPercent(int preferredLeftPercent)
    {
        iPreferredLeftPercent.setValue(preferredLeftPercent);
    }

    /**
     * Returns top of the upper-left corner as a percentage of screen width
     *
     * @return The top of the upper-left corner as a percentage of screen width
     */
    public int getPreferredTopPercent()
    {
        return (int)iPreferredTopPercent.getValue();
    }

    /**
     * Sets top of the upper-left corner as a percentage of screen width
     *
     * @param preferredTopPercent The top of the upper-left corner as a percentage of screen width
     */
    public void setPreferredTopPercent(int preferredTopPercent)
    {
        iPreferredTopPercent.setValue(preferredTopPercent);
    }

    /**
     * Creates copy of this instance
     *
     * @return Copy of this instance
     */
    public Object clone()
    {
        return new ComponentLocation(this);
    }
}