/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.security;

import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt32;

/**
 * This structure represents a locally unique identifier and its attributes and
 * corresponds to the native <code>LUID_AND_ATTRIBUTES</code> structure.
 * <a href = "http://msdn.microsoft.com/en-us/library/aa379263(VS.85).aspx"> LUID_AND_ATTRIBUTES in MSDN Library </a>. 
 */
public class LuidAndAttributes extends Structure
{
    private Luid _luid = new Luid();
    private UInt32 _attributes = new UInt32();

    /**
     * Creates instance of the <code>Luid</code> that represents 64-bit value guaranteed to be unique only on the system on which it was generated.
     * The uniqueness of a locally unique identifier (LUID) is guaranteed only until the system is restarted.
     */
    public LuidAndAttributes()
    {
        init(new Parameter[]{_luid, _attributes});
    }

    /**
     * Creates new instance of the <code>LUID</code> and initializes it by the specified one.
     *
     * @param other The value that will be used to initialize created instance.
     */
    private LuidAndAttributes(LuidAndAttributes other)
    {
        this();
        this.initFrom(other);
    }

    /**
     * Returns locally unique identifier.
     *
     * @return Locally unique identifier.
     */
    public Luid getLuid()
    {
        return _luid;
    }

    /**
     * Returns the attributes.
     *
     * @return The attributes.
     */
    public int getAttributes()
    {
        return (int) _attributes.getValue();
    }

    /**
     * Sets the attributes.
     *
     * @param attributes The attributes.
     */
    public void setAttributes(int attributes)
    {
        _attributes.setValue(attributes);
    }

    /**
     * Creates copy of this instance.
     *
     * @return The copy of this instance.
     */
    public Object clone()
    {
        LuidAndAttributes luidAndAttributes = new LuidAndAttributes();
        luidAndAttributes.initFrom(this);
        return luidAndAttributes;
    }
}