/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.hook.data;

import com.jniwrapper.*;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.ui.Wnd;

/**
 * This class represents the wrapper for the <code>CREATESTRUCT</code> structure.
 *
 * @see <a href="http://msdn.microsoft.com/en-us/library/ms632603(VS.85).aspx">Microsoft COM SDK documentation</a>
 */
public class CREATESTRUCT extends Structure
{
    private Handle createParams = new Handle();
    private Handle instance = new Handle();
    private Handle menu = new Handle();
    private Wnd parent = new Wnd();
    private Int cy = new Int();
    private Int cx = new Int();
    private Int y = new Int();
    private Int x = new Int();
    private LongInt style = new LongInt();
    private Str name = new Str();
    private Str className = new Str();
    private UInt32 exStyle = new UInt32();

    public CREATESTRUCT()
    {
        init(new Parameter[]{
                createParams,
                instance,
                menu,
                parent,
                cy,
                cx,
                y,
                x,
                style,
                new Pointer(name),
                new Pointer(className),
                exStyle
        }, (short) 8);
    }

    public Handle getCreateParams()
    {
        return createParams;
    }

    public Handle getInstance()
    {
        return instance;
    }

    public Handle getMenu()
    {
        return menu;
    }

    public Wnd getParent()
    {
        return parent;
    }

    public Int getCy()
    {
        return cy;
    }

    public Int getCx()
    {
        return cx;
    }

    public Int getY()
    {
        return y;
    }

    public Int getX()
    {
        return x;
    }

    public LongInt getStyle()
    {
        return style;
    }

    public Str getName()
    {
        return name;
    }

    public Str getClassName()
    {
        return className;
    }

    public UInt32 getExStyle()
    {
        return exStyle;
    }

//    public String toString()
//    {
//        StringBuffer result = new StringBuffer(getClass().getName()).append('[');
//        result.append("createParams=").append(createParams);
//        result.append(";instance=").append(instance);
//        result.append(";menu=").append(menu);
//        result.append(";parent=").append(parent);
//        result.append(";cx=").append(cx);
//        result.append(";cy=").append(cy);
//        result.append(";x=").append(x);
//        result.append(";y=").append(y);
//        result.append(";style=").append(style);
//        result.append(";name=").append(name);
//        result.append(";className=").append(className);
//        result.append(";exStyle=").append(exStyle);
//        result.append(']');
//        return result.toString();
//    }
}