/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.hook.data;

import com.jniwrapper.Structure;
import com.jniwrapper.Pointer;
import com.jniwrapper.Parameter;
import com.jniwrapper.win32.ui.Wnd;

/**
 * This class represents the wrapper for the <code>CBT_CREATEWND</code> structure.
 *
 * @see <a href="http://msdn.microsoft.com/en-us/library/ms644962(VS.85).aspx">Microsoft COM SDK documentation</a>
 */
class CBT_CREATEWND extends Structure
{
    private CREATESTRUCT createstruct = new CREATESTRUCT();
    private Wnd insertAfter = new Wnd();

    public CBT_CREATEWND()
    {
        init(new Parameter[] {new Pointer(createstruct), insertAfter}, (short) 8);
    }

    public CREATESTRUCT getCreatestruct()
    {
        return createstruct;
    }

    public Wnd getInsertAfter()
    {
        return insertAfter;
    }
}