/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.hook.data;

import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Bool;
import com.jniwrapper.win32.IntPtr;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.ui.Wnd;

class CBTProcData extends AbstractHookData
{
    private Int nCode = new Int();
    protected IntPtr wParam = new IntPtr();
    protected IntPtr lParam = new IntPtr();
    protected CBTACTIVATESTRUCT activeStruct;
    protected MouseHookStructure mouseHookStruct;
    protected Rect rect;
    // Fields of CBT_CREATEWND structure
    protected CREATESTRUCT createstruct;
    protected Wnd insertAfter = new Wnd();
    protected Bool allow = new Bool();

    public CBTProcData()
    {
        activeStruct = new CBTACTIVATESTRUCT();
        mouseHookStruct = new MouseHookStructure();
        rect = new Rect();

        createstruct = new CREATESTRUCT();

        init(new Parameter[]{
                _hookHandle,
                _syncronous,
                _eventDescriptor,
                nCode,
                wParam,
                lParam,
                rect,
                activeStruct,
                mouseHookStruct,
                createstruct,
                insertAfter,
                allow
        }, (short) 1);
    }

    public int getCode()
    {
        return (int) nCode.getValue();
    }

    public long getWParam()
    {
        return wParam.getValue();
    }

    public long getLParam()
    {
        return lParam.getValue();
    }

    public CBTACTIVATESTRUCT getActiveStruct()
    {
        return activeStruct;
    }

    public MouseHookStructure getMouseHookStruct()
    {
        return mouseHookStruct;
    }

    public Rect getRect()
    {
        return rect;
    }

    public Bool getAllow()
    {
        return allow;
    }

    public CREATESTRUCT getCreatestruct()
    {
        return createstruct;
    }

    public Wnd getInsertAfter()
    {
        return insertAfter;
    }
}