package com.jniwrapper.win32.hook;

import com.jniwrapper.Bool;
import com.jniwrapper.Pointer;

/**
 * Provides implementation of low-level mouse hook.
 *
 * @author Serge Piletsky
 */
final public class LowLevelMouseHook extends LowLevelHook
{
    final MouseHookStruct mouseStructure = new MouseHookStruct();
    final Pointer structurePointer = new Pointer(mouseStructure);

    public LowLevelMouseHook()
    {
        super(Descriptor.MOUSE_LL);
    }

    protected long processEvent(long wParam, long lParam)
    {
        if (lParam != 0)
        {
            Pointer.Void structureHandle = new Pointer.Void(lParam);
            structureHandle.castTo(structurePointer);
            Bool consume = new Bool(false);
            LowLevelMouseEvent event = new LowLevelMouseEvent(this, wParam, mouseStructure, consume);
            notifyListeners(event);
            if (consume.getValue())
            {
                return CONSUME_ACTION;
            }
            else
            {
                return 0;
            }
        }
        else
        {
            return 0;
        }
    }
}
