package com.jniwrapper.win32.hook;

import com.jniwrapper.Bool;
import com.jniwrapper.win32.Msg;
import com.jniwrapper.win32.Point;

/**
 * Defines low level mouse event object.
 *
 * @author Serge Piletsky
 */
public class LowLevelMouseEvent extends HookEventObject
{
    private MouseHookStruct _mouseData;
    private long _messageID;
    private Bool _consume;

    LowLevelMouseEvent(Object source, long message, MouseHookStruct mouseData, Bool consume)
    {
        super(source);
        _mouseData = mouseData;
        _messageID = message;
        _consume = consume;
    }

    /**
     * Retursn structure that contains the x- and y-coordinates of the cursor, in screen coordinates.
     *
     * @return coordinates of the cursor
     */
    public Point getPoint()
    {
        com.jniwrapper.win32.Point point = _mouseData.getPoint();
        return new Point((int) point.getX(), (int) point.getY());
    }

    /**
     * Returns the identifier of the mouse message.
     *
     * @return mouse event identifier
     */
    public long getMessageID()
    {
        return _messageID;
    }

    /**
     * Returns the mouse wheel delta.
     *
     * @return mouse delta value if available or null if not a mouse wheel event
     */
    public Byte getWheelDelta()
    {
        if (getMessageID() == Msg.WM_MOUSEWHEEL)
        {
            long mouseData = _mouseData.getMouseData().getValue();
            byte value = (byte) ((0xFFFF0000 & mouseData) >>> 16);
            return new Byte(value);
        }
        return null;
    }

    /**
     * Returns the time stamp for this message.
     *
     * @return time stamp
     */
    public long getTime()
    {
        return _mouseData.getTime().getValue();
    }

    /**
     * Causes the consuming of this event, so another applications will not receive it.
     */
    public void consume()
    {
        _consume.setValue(true);
    }
}
