/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.*;

// TODO [leha]: comments
/**
 * The LogPalette class represents the LOGPALETTE structure.
 * <a href = "http://msdn.microsoft.com/en-us/library/dd145040(VS.85).aspx">  LOGPALETTE in MSDN Library </a>
 */
public class LogPalette extends Structure
{
    private UInt16 _palVersion;
    private UInt16 _palNumEntries;
    private Pointer _palPalEntry;

    /**
     *  Creates new logical palette.
     */
    public LogPalette()
    {
        _palVersion = new UInt16();
        _palNumEntries = new UInt16();
        _palPalEntry = new Pointer(new PaletteEntry());

        init();
    }

    /**
     * Creates new instance of the <code>LogPalette</code> and initializes it by the specified one.
     *
     * @param that Instance of the <code>LogPalette</code> that will be used to initialize created instance.
     */
    public LogPalette(LogPalette that)
    {
        _palVersion = (UInt16)that._palVersion.clone();
        _palNumEntries = (UInt16)that._palNumEntries.clone();
        _palPalEntry = (Pointer)that._palPalEntry.clone();

        init();
    }

    private void init()
    {
        init(
                new Parameter[]{
                    _palVersion,
                    _palNumEntries,
                    _palPalEntry
                }, (short)4
        );
    }

    /**
     * Returns value that specifies the version number of the system.
     *
     * @return The version number of the system.
     */
    public UInt16 getPalVersion()
    {
        return _palVersion;
    }

    /**
     * Returns the value that specifies the number of entries in the logical palette.
     *
     * @return The number of entries in the logical palette.
     */
    public UInt16 getPalNumEntries()
    {
        return _palNumEntries;
    }

    /**
     * Returns an array of {@link PaletteEntry} instances that define the color and usage of each entry in the logical palette.
     *
     * @return An array of {@link PaletteEntry} instances that define the color and usage of each entry in the logical palette.
     */
    public Pointer getPalPalEntry()
    {
        return _palPalEntry;
    }

    /**
     * Creates copy of this instance.
     * 
     * @return The copy of this instance.
     */
    public Object clone()
    {
        return new LogPalette(this);
    }
}