/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.*;

/** The LogFont class represents the LOGFONT structure.
 * <a href = "http://msdn.microsoft.com/en-us/library/ms901140.aspx"> LOGFONT in MSDN Library</a>
 */
public class LogFont extends Structure
{
    /**
     * Specifies the height, in logical units, of the font's character cell or character.
     */
    protected LongInt lfHeight = new LongInt();
    /**
     * Specifies the average width, in logical units, of characters in the font.
     */
    protected LongInt lfWidth = new LongInt();
    /**
     * Specifies the angle, in tenths of degrees, between the escapement vector and the x-axis of the device.
     * The escapement vector is parallel to the base line of a row of text.
     */
    protected LongInt lfEscapement = new LongInt();
    /**
     * Specifies the angle, in tenths of degrees, between each character's base line and the x-axis of the device.
     */
    protected LongInt lfOrientation = new LongInt();
    /**
     * Specifies the weight of the font in the range 0 through 1000.
     */
    protected LongInt lfWeight = new LongInt();
    /**
     * Specifies an italic font if set to true.
     */
    protected UInt8 lfItalic = new UInt8();
    /**
     * Specifies an underlined font if set to true.
     */
    protected UInt8 lfUnderline = new UInt8();
    /**
     * Specifies a strikeout font if set to true.
     */
    protected UInt8 lfStrikeOut = new UInt8();
    /**
     * Specifies the character set.
     */
    protected UInt8 lfCharSet = new UInt8();
    /**
     * Specifies the output precision. The output precision defines how closely the output must match the requested
     * font's height, width, character orientation, escapement, pitch, and font type.
     */
    protected UInt8 lfOutPrecision = new UInt8();
    /**
     * Specifies the clipping precision. The clipping precision defines how to clip characters that are partially
     * outside the clipping region.
     */
    protected UInt8 lfClipPrecision = new UInt8();
    /**
     * Specifies the output quality. The output quality defines how carefully the graphics device interface (GDI) must
     * attempt to match the logical-font attributes to those of an actual physical font.
     */
    protected UInt8 lfQuality = new UInt8();
    /**
     * Specifies the pitch and family of the font.
     */
    protected UInt8 lfPitchAndFamily = new UInt8();
    /**
     * Specifies a null-terminated string that contains the typeface name of the font.
     *  The length of this string must not exceed 32 characters, including the terminating null character.
     */
    protected Str lfFaceName = new Str(32);

    /**
     * Creates new set of the attributes of a font.
     */
    public LogFont()
    {
        init(new Parameter[] {
            lfHeight, lfWidth, lfEscapement, lfOrientation, lfWeight,
            lfItalic, lfUnderline, lfStrikeOut, lfCharSet,
            lfOutPrecision, lfClipPrecision,
            lfQuality, lfPitchAndFamily,
            lfFaceName
        });
    }

    /**
     * Create new instance of the <code>LogFont</code> and initializes it by the specified one.
     *
     * @param that Instance of the <code>LogFont</code> that will be used for initializing a new instance.
     */
    public LogFont(LogFont that)
    {
        this();
        initFrom(that);
    }

    /**
     * Returns value that specifies the height, in logical units, of the font character cell or character.
     *
     * @return The height, in logical units, of the font character cell or character.
     */
    public LongInt getLfHeight()
    {
        return lfHeight;
    }

    /**
     * Returns value that specifies the angle, in tenths of degrees, between the escapement vector and the x-axis of the device.
     *
     * @return The angle, in tenths of degrees, between the escapement vector and the x-axis of the device.
     */
    public LongInt getLfWidth()
    {
        return lfWidth;
    }

    /**
     * Returns value that specifies the angle, in tenths of degrees, between the escapement vector and the x-axis of the device.
     *
     * @return The angle, in tenths of degrees, between the escapement vector and the x-axis of the device.
     */
    public LongInt getLfEscapement()
    {
        return lfEscapement;
    }

    /**
     * Returns value that specifies the angle, in tenths of degrees, between each character's base line and the x-axis of the device.
     *
     * @return  The angle, in tenths of degrees, between each character's base line and the x-axis of the device.
     */
    public LongInt getLfOrientation()
    {
        return lfOrientation;
    }

    /**
     * Returns value that specifies the weight of the font in the range 0 through 1000.
     *
     * @return The weight of the font in the range 0 through 1000.
     */
    public LongInt getLfWeight()
    {
        return lfWeight;
    }

    public UInt8 getLfItalic()
    {
        return lfItalic;
    }

    /**
     * Returns value that specifies an underlined font if set to true.
     *
     * @return Value that specifies an underlined font if set to true
     */
    public UInt8 getLfUnderline()
    {
        return lfUnderline;
    }

    /**
     * Returns value that specifies a strikeout font if set to true.
     *
     * @return Value that specifies a strikeout font if set to true.
     */
    public UInt8 getLfStrikeOut()
    {
        return lfStrikeOut;
    }

    /**
     * Returns the character set.
     *
     * @return The character set.
     */
    public UInt8 getLfCharSet()
    {
        return lfCharSet;
    }

    /**
     * Returns the output precision.
     *
     * @return The output precision.
     */
    public UInt8 getLfOutPrecision()
    {
        return lfOutPrecision;
    }

    /**
     * Returns the clipping precision.
     *
     * @return The clipping precision.
     */
    public UInt8 getLfClipPrecision()
    {
        return lfClipPrecision;
    }

    /**
     * Returns the output quality.
     *
     * @return The output quality.
     */
    public UInt8 getLfQuality()
    {
        return lfQuality;
    }

    /**
     * Returns the pitch and family of the font.
     *
     * @return The pitch and family of the font.
     */
    public UInt8 getLfPitchAndFamily()
    {
        return lfPitchAndFamily;
    }

    /**
     * Returns null-terminated string that specifies the typeface name of the font.
     *
     * @return null-terminated string that specifies the typeface name of the font.
     */
    public Str getLfFaceName()
    {
        return lfFaceName;
    }

    /**
     * Creates copy of this object.
     *
     * @return Copy of this object.
     */
    public Object clone()
    {
        return new LogFont(this);
    }
}