/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.ULongInt;

/**
 * Represents GRADIENT_RECT native structure.
 */
public class GradientRect extends Structure
{
    private ULongInt _upperLeft = new ULongInt();
    private ULongInt _lowerRight = new ULongInt();


    /**
     * Creates new instance of the <code>GradientRect</code>.
     */
    public GradientRect()
    {
        init(new Parameter[] {_upperLeft, _lowerRight});
    }

    /**
     * Creates new instance of the <code>GradientRect</code> and initializes it by the specified one.
     *
     * @param that Instance of the <code>GradientRect</code>. The new instance will have same properties as this one.
     */
    public GradientRect(GradientRect that)
    {
        this();
        initFrom(that);
    }

    /**
     * Returns the upper-left corner of a rectangle.
     *
     * @return The upper-left corner of a rectangle
     */
    public long getUpperLeft()
    {
        return _upperLeft.getValue();
    }

    /**
     * Sets the upper-left corner of a rectangle.
     *
      * @param upperLeft The upper-left corner of a rectangle.
     */
    public void setUpperLeft(long upperLeft)
    {
        _upperLeft.setValue(upperLeft);
    }

    /**
     * Returns the lower-right corner of a rectangle.
     *
     * @return The lower-right corner of a rectangle.
     */
    public long getLowerRight()
    {
        return _lowerRight.getValue();
    }

    /**
     * Sets the lower-right corner of a rectangle.
     *
     * @param lowerRight The lower-right corner of a rectangle.
     */
    public void setLowerRight(long lowerRight)
    {
        _lowerRight.setValue(lowerRight);
    }

    /**
     * Creates copy of this instance
     * @return The copy of this instance
     */
    public Object clone()
    {
        return new GradientRect(this);
    }
}