/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.*;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.WinFunctionCache;

/**
 * This class provides a wrapper over Win32 GDI functions.
 *
 * @author Alexander Evsukov
 */
public class Gdi32 extends WinFunctionCache
{
    static final String FUNCTION_GET_STOCK_OBJECT = "GetStockObject";
    static final String FUNCTION_ENUM_FONT_FAMILIES = "EnumFontFamilies";

    private static Gdi32 _instance;

    public Gdi32()
    {
        super("gdi32");
    }

    public static Gdi32 getInstance()
    {
        if (_instance == null)
        {
            _instance = new Gdi32();
        }

        return _instance;
    }

    /**
     * Use this method for getting actual instances of objects that correspond
     * to stock object constants.
     *
     * @param objectType a stock object type defined by Windows API.
     * @return handle to the stock object.
     */
    public static Handle getStockObject(int objectType)
    {
        Function function = getInstance().getFunction(FUNCTION_GET_STOCK_OBJECT);
        Int brType = new Int(objectType);
        Handle handle = new Handle();
        long errorCode = function.invoke(handle, brType);
        if (handle.getValue() == 0)
        {
            throw new LastErrorException(errorCode, "Failed to get stock object", true);
        }
        return handle;
    }

    public static Function get(String functionName)
    {
        return getInstance().getFunction(functionName);
    }

    public static void enumFontFamilies() {
        WindowDC dc = new WindowDC(0);
        Int32 lparam = new Int32();
        EnumFamCallBack callBack = new EnumFamCallBack();
        Function f = getInstance().getFunction(FUNCTION_ENUM_FONT_FAMILIES);
        f.invoke(null, dc, new UInt32(0), new Pointer(callBack), lparam);
    }

    public static void main(String[] args) {
        enumFontFamilies();
    }
}