/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.win32.FunctionName;

/**
 * The Font class represents the HFONT type.
 */
public class Font extends GdiObject
{
    private static final FunctionName FUNCTION_CREATE_FONT_INDIRECT = new FunctionName("CreateFontIndirect");

    /**
     * Creates instance of the <code>Font</code>
     */
    public Font()
    {
    }

    /**
     * Creates instance of the <code>Font</code>
     *
     * @param value Value of the {@link com.jniwrapper.win32.Handle} that determinates <code>Font</code> object 
     */
    public Font(long value)
    {
        super(value);
    }

    /**
     * Creates a logical font that has the specified characteristics
     *
     * @param logFont The attributes of a font
     * @return Logical font that has the specified characteristics
     */
    public static Font createFontIndirect(LogFont logFont)
    {
        Font result = new Font();
        Gdi32.getInstance().getFunction(FUNCTION_CREATE_FONT_INDIRECT.toString()).invoke(
                result,
                new Parameter[] { new Pointer(logFont) });

        return result;
    }
}