/*
 * Copyright (c) 2000-2009 TeamDev Ltd. All rights reserved.
 * TeamDev PROPRIETARY and CONFIDENTIAL.
 * Use is subject to license terms.
 */
package com.jniwrapper.win32;

import com.jniwrapper.Pointer;

/**
 * This class represents <code>LONG_PTR</code> native type. This is guaranteed
 * to be the same size as a pointer.  Its size with change with pointer size (32/64).
 * It should be used anywhere that a pointer is cast to an Int32 type.
 *
 * @author Vadim Steshenko
 */
public class IntPtr extends Pointer.Void
{
    /**
     * Constucts a blank instance.
     */
    public IntPtr()
    {
        super();
    }

    /**
     * Constructs with the passed value.
     *
     * @param value value.
     */
    public IntPtr(long value)
    {
        super(value);
    }

    public Object clone()
    {
        return new IntPtr(this.getValue());
    }
}