import com.jniwrapper.*;
import com.jniwrapper.win32.FunctionName;

/**
 * Sample demonstrates how to use 'WNetAddConnection2' API function from MPR library.
 */
public class WNetAddConnection2Sample {
    public static class LPNETRESOURCE extends Structure {
        private UInt32 dwScope = new UInt32(0);
        private UInt32 dwType = new UInt32(1);
        private UInt32 dwDisplayType = new UInt32(0);
        private UInt32 dwUsage = new UInt32(0);
        private Str lpLocalName = new Str("G:");
        private Str lpRemoteName = new Str("\\\\nas1\\files"); // \\computer_name\folder
        private Str lpComment = new Str();
        private Str lpProvider = new Str();

        public LPNETRESOURCE() {
            init(new Parameter[]{
                    dwScope, dwType, dwDisplayType, dwUsage,
                    new Pointer(lpLocalName),
                    new Pointer(lpRemoteName),
                    new Pointer(lpComment),
                    new Pointer(lpProvider)
            }, (short) 8);
        }
    }

    public static void main(String[] args) {
        Library mpr = new Library("Mpr");
        Function wNetAddConnection2 = mpr.getFunction(new FunctionName("WNetAddConnection2").toString());
        UInt32 result = new UInt32();
        LPNETRESOURCE netResource = new LPNETRESOURCE();
        wNetAddConnection2.invoke(result, new Parameter[]{
                new Pointer(netResource), // function expects LPNETRESOURCE or *NETRESOURCE, so it should be a pointer to a structure
                new Pointer(null, true), // password
                new Pointer(null, true), // username
                new Int32()});

        if (result.getValue() == 0 /*NO_ERROR*/) {
            System.out.println("Connection added");
        } else {
            System.out.println("WNetAddConnection2 failed with error: " + result.getValue());
        }
    }
}
