/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.unix.system.io;

import com.jniwrapper.AnsiString;
import com.jniwrapper.Function;
import com.jniwrapper.Int32;
import com.jniwrapper.Library;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.unix.system.LastError;
import com.jniwrapper.unix.system.TimeSpec;
import com.jniwrapper.unix.system.io.FileSystemEvent;
import com.jniwrapper.unix.system.io.FileSystemEventListener;
import com.jniwrapper.unix.system.io.KEvent;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.util.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileSystemWatcher {
    private static final Logger LOG = Logger.getInstance((Class)(class$com$jniwrapper$unix$system$io$FileSystemWatcher == null ? (class$com$jniwrapper$unix$system$io$FileSystemWatcher = FileSystemWatcher.class$("com.jniwrapper.unix.system.io.FileSystemWatcher")) : class$com$jniwrapper$unix$system$io$FileSystemWatcher));
    private File _watchedFolder;
    private FileFilter _fileFilter;
    private boolean _watchSubtree = false;
    private List _fileSystemListeners = Collections.synchronizedList(new LinkedList());
    private Map _descriptor2FolderMap = new HashMap();
    private Thread _watcherThread;
    private boolean _watching = false;
    private Int32 _queue = new Int32();
    private WatcherOptions _notifyOptions = new WatcherOptions();
    private static final int ROOT_FOLDER = -1;
    private static final String FUNCTION_kqueue = "kqueue";
    private static final String FUNCTION_kevent = "kevent";
    private static final String FUNCTION_open = "open";
    private static final String FUNCTION_close = "close";
    private static Function _kqueue;
    private static Function _kevent;
    private static Function _open;
    private static Function _close;
    static /* synthetic */ Class class$com$jniwrapper$unix$system$io$FileSystemWatcher;

    public FileSystemWatcher(File folder) {
        if (folder == null) {
            throw new IllegalArgumentException();
        }
        if (!folder.exists()) {
            throw new IllegalArgumentException("Folder does not exist");
        }
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("Specified parameter is not a folder");
        }
        this._watchedFolder = folder;
    }

    public FileSystemWatcher(File folder, FileFilter fileFilter, boolean watchSubtree) {
        this(folder, watchSubtree);
        this._fileFilter = fileFilter;
    }

    public FileSystemWatcher(File folder, FileFilter fileFilter) {
        this(folder);
        this._fileFilter = fileFilter;
    }

    public FileSystemWatcher(File folder, boolean watchSubtree) {
        this(folder);
        this._watchSubtree = watchSubtree;
    }

    public FileSystemWatcher(String folder) {
        this(new File(folder));
    }

    public FileSystemWatcher(String folder, FileFilter fileFilter, boolean watchSubtree) {
        this(new File(folder), fileFilter, watchSubtree);
    }

    public FileSystemWatcher(String folder, FileFilter fileFilter) {
        this(new File(folder), fileFilter);
    }

    public FileSystemWatcher(String folder, boolean watchSubtree) {
        this(new File(folder), watchSubtree);
    }

    public File getWatchedFolder() {
        return this._watchedFolder;
    }

    public FileFilter getFileFilter() {
        return this._fileFilter;
    }

    public boolean isWatchSubtree() {
        return this._watchSubtree;
    }

    public WatcherOptions getOptions() {
        return this._notifyOptions;
    }

    public boolean isWatching() {
        return this._watching;
    }

    public void addFileSystemListener(FileSystemEventListener listener) {
        if (!this._fileSystemListeners.contains(listener)) {
            this._fileSystemListeners.add(listener);
        }
    }

    public void removeFileSystemListener(FileSystemEventListener listener) {
        this._fileSystemListeners.remove(listener);
    }

    public void start() {
        if (this._watcherThread != null && this._watcherThread.isAlive() && this._watching) {
            return;
        }
        this.startWatching();
    }

    public void stop() {
        this._watching = false;
        try {
            this._watcherThread.join();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        this.unregisterDescriptors(this._descriptor2FolderMap.keySet());
        this._descriptor2FolderMap.clear();
    }

    private void startWatching() {
        this._watcherThread = new Thread(new Runnable(){

            public void run() {
                try {
                    LastError.setValue(0L);
                    _kqueue.invoke((Parameter)FileSystemWatcher.this._queue);
                    FileSystemWatcher.this.associateFile(-1, FileSystemWatcher.this._watchedFolder, true);
                    FileSystemWatcher.this._watching = true;
                    while (FileSystemWatcher.this._watching) {
                        FileEvent fileEvent = FileSystemWatcher.this.getForNextFileEvent();
                        if (fileEvent == null) continue;
                        List events = FileSystemWatcher.this.processEvent(fileEvent.getFileDescriptor(), fileEvent.getEventDescriptor());
                        for (int i = 0; i < events.size(); ++i) {
                            FileSystemWatcher.this.fireFileSystemEvent((FileSystemEvent)events.get(i));
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"", (Throwable)e);
                }
            }
        });
        this._watcherThread.start();
    }

    private List processEvent(int fileDescriptor, int eventDescriptor) {
        ArrayList<FileSystemEvent> events = new ArrayList<FileSystemEvent>(0);
        FileInfo fileInfo = this.getFileInfoByDescriptor(fileDescriptor);
        if (fileInfo == null) {
            return null;
        }
        String eventFileName = fileInfo.getFullPath();
        if (fileInfo.isDirectory() && ((long)eventDescriptor & 2L) != 0L) {
            if (((long)eventDescriptor & 1L) != 0L) {
                FolderInfo folderInfo;
                int parent = fileInfo.getParent();
                if (parent != -1 && (folderInfo = (FolderInfo)this.getFileInfoByDescriptor(parent)) != null) {
                    folderInfo.del(fileDescriptor);
                    this.associateDescriptor2File(parent, folderInfo);
                }
                FileSystemWatcher.closeFileDescriptor(fileDescriptor);
                this.removeDescriptor2File(fileDescriptor);
                events.add(new FileSystemEvent(this, 1, eventFileName));
            } else {
                events.addAll(this.scanFolderChanges(fileDescriptor, (FolderInfo)fileInfo));
            }
        } else if (((long)eventDescriptor & 2L) != 0L) {
            events.add(new FileSystemEvent(this, 2, eventFileName));
        } else if (((long)eventDescriptor & 8L) != 0L) {
            events.add(new FileSystemEvent(this, 2, eventFileName));
        } else if (((long)eventDescriptor & 0x20L) != 0L) {
            if (fileInfo.getParent() == -1) {
                events.add(new FileSystemEvent(this, 3, eventFileName));
            }
        } else if (((long)eventDescriptor & 1L) != 0L) {
            int parent = fileInfo.getParent();
            FolderInfo folderInfo = (FolderInfo)this.getFileInfoByDescriptor(parent);
            if (parent != -1 && folderInfo != null) {
                folderInfo.del(fileDescriptor);
                this.associateDescriptor2File(parent, folderInfo);
            }
            FileSystemWatcher.closeFileDescriptor(fileDescriptor);
            this.removeDescriptor2File(fileDescriptor);
            events.add(new FileSystemEvent(this, 1, eventFileName));
            events.addAll(this.scanFolderChanges(parent, folderInfo));
        }
        return events;
    }

    private List scanFolderChanges(int folderDescriptor, FolderInfo folder) {
        ArrayList<FileSystemEvent> events = new ArrayList<FileSystemEvent>(0);
        if (folder != null) {
            File file = new File(folder.getFullPath());
            List newFileNames = this.getFileNames(file.listFiles(this._fileFilter));
            List oldFileNames = folder.getFiles();
            if (newFileNames.size() > oldFileNames.size()) {
                newFileNames.removeAll(oldFileNames);
                FolderInfo newFolderInfo = new FolderInfo(folder);
                for (int i = 0; i < newFileNames.size(); ++i) {
                    String eventFolderName = folder.getFullPath() + File.separatorChar + newFileNames.get(i).toString();
                    file = new File(eventFolderName);
                    int descriptor = this.associateFile(folderDescriptor, file, false);
                    newFolderInfo.add(descriptor);
                    events.addAll(this.associateEvents(descriptor));
                }
                this.associateDescriptor2File(folderDescriptor, newFolderInfo);
            } else if (newFileNames.size() == oldFileNames.size()) {
                ArrayList tmpFileNames = new ArrayList(newFileNames);
                newFileNames.removeAll(oldFileNames);
                oldFileNames.removeAll(tmpFileNames);
                if (!newFileNames.isEmpty() && !oldFileNames.isEmpty()) {
                    String oldFileName = folder.getFullPath() + File.separatorChar + oldFileNames.get(0);
                    String eventFolderName = folder.getFullPath() + File.separatorChar + newFileNames.get(0);
                    int descriptor = folder.getDescriptorByName(oldFileNames.get(0).toString());
                    FileInfo newFileInfo = this.getFileInfoByDescriptor(descriptor);
                    newFileInfo.setName(new File(eventFolderName));
                    this.associateDescriptor2File(descriptor, newFileInfo);
                    events.add(new FileSystemEvent(this, 3, oldFileName, eventFolderName));
                }
            } else if (newFileNames.size() < oldFileNames.size()) {
                oldFileNames.removeAll(newFileNames);
                FolderInfo newFolderInfo = new FolderInfo(folder);
                for (int i = 0; i < oldFileNames.size(); ++i) {
                    int descriptor = folder.getDescriptorByName(oldFileNames.get(i).toString());
                    FileInfo delFileInfo = this.getFileInfoByDescriptor(descriptor);
                    String eventFolderName = delFileInfo.getFullPath();
                    FileSystemWatcher.closeFileDescriptor(descriptor);
                    this.removeDescriptor2File(descriptor);
                    newFolderInfo.del(descriptor);
                    events.add(new FileSystemEvent(this, 1, eventFolderName));
                }
                this.associateDescriptor2File(folderDescriptor, newFolderInfo);
            }
        }
        return events;
    }

    private void fireFileSystemEvent(FileSystemEvent event) {
        Iterator i = this._fileSystemListeners.iterator();
        while (i.hasNext()) {
            FileSystemEventListener listener = (FileSystemEventListener)i.next();
            listener.handle(event);
        }
    }

    private void unregisterDescriptors(Set descriptors) {
        Iterator i = descriptors.iterator();
        while (i.hasNext()) {
            int descriptor = (Integer)i.next();
            this.unregisterDescriptor(descriptor);
        }
    }

    private void registerDescriptor(int descriptor) {
        KEvent event = new KEvent(descriptor, -4, 37, this._notifyOptions.getFlags());
        TimeSpec time = new TimeSpec();
        Int32 error = new Int32();
        _kevent.invoke((Parameter)error, new Parameter[]{this._queue, new Pointer((Parameter)event), new Int32(1), new Pointer.Void(), new Int32(), new Pointer((Parameter)time)});
        if (error.getValue() == -1L) {
            throw new RuntimeException(LastError.getMessage());
        }
    }

    private void unregisterDescriptor(int descriptor) {
        KEvent event = new KEvent(descriptor, -4, 2, 0L);
        TimeSpec time = new TimeSpec();
        Int32 error = new Int32();
        _kevent.invoke((Parameter)error, new Parameter[]{this._queue, new Pointer((Parameter)event), new Int32(1), new Pointer.Void(), new Int32(), new Pointer((Parameter)time)});
        if (error.getValue() == -1L) {
            throw new RuntimeException(LastError.getMessage());
        }
        FileSystemWatcher.closeFileDescriptor(descriptor);
    }

    private FileEvent getForNextFileEvent() {
        Int32 count = new Int32();
        KEvent event = new KEvent();
        TimeSpec time = new TimeSpec(10L);
        _kevent.invoke((Parameter)count, new Parameter[]{this._queue, new Pointer.Void(), new Int32(), new Pointer((Parameter)event), new Int32(1), new Pointer((Parameter)time)});
        if (count.getValue() > 0L) {
            return new FileEvent((int)event.getIdent(), (int)event.getFflags());
        }
        return null;
    }

    private List getFileNames(File[] files) {
        if (files != null) {
            ArrayList<String> result = new ArrayList<String>(files.length);
            for (int i = 0; i < files.length; ++i) {
                result.add(files[i].getName());
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    private int associateFile(int parent, File file, boolean root) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        int fileDescriptor = this.openFileDescriptor(file);
        if (file.isDirectory() && (this._watchSubtree || root)) {
            File[] files = file.listFiles(this._fileFilter);
            if (files != null) {
                ArrayList<Integer> descriptors = new ArrayList<Integer>(files.length);
                for (int i = 0; i < files.length; ++i) {
                    descriptors.add(new Integer(this.associateFile(fileDescriptor, files[i], false)));
                }
                this.associateDescriptor2File(fileDescriptor, parent, file, descriptors);
            }
            return fileDescriptor;
        }
        this.associateDescriptor2File(fileDescriptor, parent, file, null);
        return fileDescriptor;
    }

    private List associateEvents(int descriptor) {
        ArrayList<FileSystemEvent> events = new ArrayList<FileSystemEvent>(1);
        FileInfo fileInfo = this.getFileInfoByDescriptor(descriptor);
        events.add(new FileSystemEvent(this, 0, fileInfo.getFullPath()));
        if (fileInfo.isDirectory() && this._watchSubtree) {
            List descriptors = ((FolderInfo)fileInfo).getDescriptors();
            for (int i = 0; i < descriptors.size(); ++i) {
                events.addAll(this.associateEvents((Integer)descriptors.get(i)));
            }
        }
        return events;
    }

    private void associateDescriptor2File(int descriptor, FileInfo fileInfo) {
        this._descriptor2FolderMap.put(new Integer(descriptor), fileInfo);
    }

    private void associateDescriptor2File(int descriptor, int parent, File file, List fileDescriptors) {
        FileInfo fileInfo = file.isFile() ? new FileInfo(parent, file) : new FolderInfo(parent, file, fileDescriptors);
        this._descriptor2FolderMap.put(new Integer(descriptor), fileInfo);
    }

    private void removeDescriptor2File(int descriptor) {
        FileInfo fileInfo = this.getFileInfoByDescriptor(descriptor);
        if (fileInfo.isDirectory()) {
            FolderInfo folderInfo = (FolderInfo)fileInfo;
            List fDescriptors = folderInfo.getDescriptors();
            for (int i = 0; i < fDescriptors.size(); ++i) {
                int fDescriptor = (Integer)fDescriptors.get(i);
                FileInfo fInfo = this.getFileInfoByDescriptor(fDescriptor);
                if (fInfo == null) continue;
                fInfo.setName(fInfo.getFullPath());
                this.associateDescriptor2File(fDescriptor, fInfo);
            }
        }
        this._descriptor2FolderMap.remove(new Integer(descriptor));
    }

    private FileInfo getFileInfoByDescriptor(int descriptor) {
        FileInfo fileInfo = (FileInfo)this._descriptor2FolderMap.get(new Integer(descriptor));
        return fileInfo;
    }

    private int openFileDescriptor(File file) {
        Int32 descriptor = new Int32();
        String fullPath = file.getAbsolutePath();
        try {
            AnsiString path = new AnsiString(fullPath.getBytes("UTF8"));
            for (int tryCount = 10; tryCount > 0; --tryCount) {
                _open.invoke((Parameter)descriptor, (Parameter)path, (Parameter)new Int32(32768));
                if (descriptor.getValue() == -1L) {
                    int errorCode = LastError.getValue();
                    if (errorCode == 2) {
                        Thread.sleep(100L);
                        continue;
                    }
                } else {
                    this.registerDescriptor((int)descriptor.getValue());
                }
                break;
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        return (int)descriptor.getValue();
    }

    private static void closeFileDescriptor(int descriptor) {
        _close.invoke(null, (Parameter)new Int32(descriptor));
    }

    public static void main(String[] args) {
        FileSystemWatcher fWatcher = new FileSystemWatcher(new File("/Users/greencat/2/testFolder"), true);
        fWatcher.addFileSystemListener(new FileSystemEventListener(){

            public void handle(FileSystemEvent event) {
                System.out.println(event);
            }
        });
        fWatcher.start();
        System.out.println("Started.");
        try {
            System.in.read();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        fWatcher.stop();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String osName = System.getProperty("os.name");
        if (!osName.equals("Linux")) {
            if (osName.startsWith("Mac")) {
                String libraryName = "/System/Library/Frameworks/System.framework/System";
                Library library = new Library(libraryName);
                _kqueue = library.getFunction(FUNCTION_kqueue);
                _kevent = library.getFunction(FUNCTION_kevent);
                _open = library.getFunction(FUNCTION_open);
                _close = library.getFunction(FUNCTION_close);
            } else {
                throw new IllegalStateException("Unsupported operation system: " + osName);
            }
        }
    }

    public class WatcherOptions
    extends FlagSet {
        public static final long NOTIFY_WRITE = 2L;
        public static final long NOTIFY_DELETE = 1L;
        public static final long NOTIFY_RENAME = 32L;
        public static final long NOTIFY_ATTRIBUTES = 8L;

        public WatcherOptions() {
            this.reset();
        }

        public void reset() {
            this.clear();
            this.add(35L);
        }

        public boolean isNotifyWrite() {
            return this.contains(2L);
        }

        public void setNotifyWrite(boolean value) {
            this.setupFlag(2L, value);
        }

        public boolean isNotifyDelete() {
            return this.contains(1L);
        }

        public void setNotifyDelete(boolean value) {
            this.setupFlag(1L, value);
        }

        public boolean isNotifyRename() {
            return this.contains(32L);
        }

        public void setNotifyRename(boolean value) {
            this.setupFlag(32L, value);
        }

        public boolean isNotifyAttributes() {
            return this.contains(8L);
        }

        public void setNotifyAttributes(boolean value) {
            this.setupFlag(8L, value);
        }
    }

    private class FolderInfo
    extends FileInfo {
        private List _descriptors;

        public FolderInfo(FolderInfo folderInfo) {
            this(folderInfo.getParent(), new File(folderInfo.getFullPath()), folderInfo.getDescriptors());
        }

        public FolderInfo(int parent, File file, List fileDescriptors) {
            super(parent, file);
            this._descriptors = fileDescriptors;
        }

        public List getDescriptors() {
            return this._descriptors;
        }

        public int getCount() {
            return this._descriptors.size();
        }

        public void add(int descriptor) {
            this._descriptors.add(new Integer(descriptor));
        }

        public void del(int descriptor) {
            this._descriptors.remove(new Integer(descriptor));
        }

        public List getFiles() {
            ArrayList<String> fileNames = new ArrayList<String>(this._descriptors.size());
            for (int i = 0; i < this._descriptors.size(); ++i) {
                Integer descriptor = (Integer)this._descriptors.get(i);
                FileInfo fileInfo = FileSystemWatcher.this.getFileInfoByDescriptor(descriptor);
                fileNames.add(fileInfo.getName());
            }
            return fileNames;
        }

        public int getDescriptorByName(String fileName) {
            for (int i = 0; i < this._descriptors.size(); ++i) {
                int descriptor = (Integer)this._descriptors.get(i);
                FileInfo fileInfo = FileSystemWatcher.this.getFileInfoByDescriptor(descriptor);
                if (!fileName.equals(fileInfo.getName())) continue;
                return descriptor;
            }
            return -1;
        }
    }

    private class FileInfo {
        private int _parent;
        private String _name;
        private boolean _isFile;
        private boolean _isDirectory;

        public FileInfo(int parent, File file) {
            this._parent = parent;
            this._name = parent == -1 ? file.getAbsolutePath() : file.getName();
            this._isFile = file.isFile();
            this._isDirectory = file.isDirectory();
        }

        public int getParent() {
            return this._parent;
        }

        public String getFullPath() {
            if (this._parent == -1) {
                return this._name;
            }
            FileInfo fileInfo = FileSystemWatcher.this.getFileInfoByDescriptor(this._parent);
            return fileInfo == null ? this._name : fileInfo.getFullPath() + '/' + this._name;
        }

        public String getName() {
            return this._name;
        }

        public void setName(File file) {
            this._name = file.getName();
        }

        public void setName(String name) {
            this._name = name;
        }

        public boolean isFile() {
            return this._isFile;
        }

        public boolean isDirectory() {
            return this._isDirectory;
        }
    }

    private static class FileEvent {
        int _fileDescriptor;
        int _eventDescriptor;

        public FileEvent(int fileDescriptor, int eventDescriptor) {
            this._fileDescriptor = fileDescriptor;
            this._eventDescriptor = eventDescriptor;
        }

        public int getFileDescriptor() {
            return this._fileDescriptor;
        }

        public int getEventDescriptor() {
            return this._eventDescriptor;
        }

        public String toString() {
            return "File event: descriptor = " + this._fileDescriptor + " event = " + this._eventDescriptor;
        }
    }
}

