/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.unix.system.io;

import com.jniwrapper.AnsiString;
import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;

class DirEntry
extends Structure {
    public static final short UNKNOWN = 0;
    public static final short FIFO = 1;
    public static final short CHR = 2;
    public static final short DIR = 4;
    public static final short BLK = 6;
    public static final short REG = 8;
    public static final short LNK = 10;
    public static final short SOCK = 12;
    public static final short WHT = 14;
    private UInt32 _fileno = new UInt32();
    private UInt16 _reclen = new UInt16();
    private UInt8 _type = new UInt8();
    private UInt8 _namelen = new UInt8();
    private AnsiString _name = new AnsiString(255);

    public DirEntry() {
        this.init(new Parameter[]{this._fileno, this._reclen, this._type, this._namelen, this._name});
    }

    public DirEntry(DirEntry that) {
        super((Structure)that);
    }

    public boolean isDirectory() {
        return this._type.getValue() == 4L;
    }

    public boolean isFile() {
        return this._type.getValue() == 8L;
    }

    public boolean isSymbolicLink() {
        return this._type.getValue() == 10L;
    }

    public int getFileno() {
        return (int)this._fileno.getValue();
    }

    public int getType() {
        return (int)this._type.getValue();
    }

    public String getName() {
        return this._name.getValue();
    }

    public Object clone() {
        return new DirEntry(this);
    }
}

