/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.unix.system;

import com.jniwrapper.ExternalStringPointer;
import com.jniwrapper.Function;
import com.jniwrapper.Int32;
import com.jniwrapper.Library;
import com.jniwrapper.Parameter;

public class LastError {
    public static final int NO_ERROR = 0;
    public static final int OPERATION_ERROR = -1;
    private static final String VARIABLE_errno = "errno";
    private static final String FUNCTION_strerror = "strerror";
    private static Int32 _errorCode = new Int32();
    private static Function _strerror;

    public static int getValue() {
        return (int)_errorCode.getValue();
    }

    public static void setValue(long errorCode) {
        _errorCode.setValue(errorCode);
    }

    public static String getMessage() {
        return LastError.getMessage(LastError.getValue());
    }

    public static String getMessage(int errorCode) {
        Int32 errCode = new Int32(errorCode);
        ExternalStringPointer message = new ExternalStringPointer(false);
        _strerror.invoke((Parameter)message, (Parameter)errCode);
        return message.readString();
    }

    static {
        String osName = System.getProperty("os.name");
        if (!osName.equals("Linux")) {
            if (osName.startsWith("Mac")) {
                String libraryName = "/System/Library/Frameworks/System.framework/System";
                Library library = new Library(libraryName);
                library.getVariable(VARIABLE_errno, (Parameter)_errorCode);
                _strerror = library.getFunction(FUNCTION_strerror);
            } else {
                throw new IllegalStateException("Unsupported operation system: " + osName);
            }
        }
    }
}

