/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.macosx.ui.controls;

import com.jniwrapper.Pointer;
import com.jniwrapper.UInt16;
import com.jniwrapper.macosx.cocoa.AwtMacMessageLoop;
import com.jniwrapper.macosx.cocoa.Id;
import com.jniwrapper.macosx.cocoa.nsarray.NSArray;
import com.jniwrapper.macosx.cocoa.nsautoreleasepool.NSAutoreleasePool;
import com.jniwrapper.macosx.cocoa.nsopenpanel.NSOpenPanel;
import com.jniwrapper.macosx.cocoa.nssavepanel.NSSavePanel;
import com.jniwrapper.macosx.cocoa.nsstring.NSString;
import com.jniwrapper.macosx.cocoa.nsurl.NSURL;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class AbstractChooseField
extends JPanel
implements ActionListener {
    protected static final int MODE_OPEN_FILE = 0;
    protected static final int MODE_SAVE_FILE = 1;
    private static final int SNOW_LEOPARD_MINOR_OS_VERSION = 6;
    private static final int MINOR_OS_VERSION;
    private JTextField _textField = new JTextField();
    private JButton _selectButton = new JButton("...");
    private NSSavePanel _dialog;
    protected int _mode = 0;
    private boolean _allowMultipleSelection = false;
    private boolean _allowInvisibleFiles = false;
    private boolean _treatsFilePackagesAsDirectories = false;
    private boolean _allowCreateDirectories = false;
    protected List _files = new ArrayList();
    private boolean _isDialogShowing = false;

    public AbstractChooseField() {
        Dimension preferredSize = new Dimension(150, 20);
        this._textField.setPreferredSize(preferredSize);
        this._textField.setMinimumSize(preferredSize);
        this._selectButton.setPreferredSize(new Dimension(30, 20));
        this.setLayout(new BorderLayout());
        this.add((Component)this._textField, "Center");
        this.add((Component)this._selectButton, "East");
        this._selectButton.addActionListener(this);
    }

    public JTextField getTextField() {
        return this._textField;
    }

    public JButton getSelectButton() {
        return this._selectButton;
    }

    protected boolean isDialogShowing() {
        return this._isDialogShowing;
    }

    protected void setDialogShowing(boolean dialogShowing) {
        this._isDialogShowing = dialogShowing;
    }

    public void setEnabled(boolean enabled) {
        this._textField.setEnabled(enabled);
        this._selectButton.setEnabled(enabled);
    }

    public boolean isAllowMultipleSelection() {
        if (this._mode == 0) {
            return this._allowMultipleSelection;
        }
        return false;
    }

    private void setMultipleSelectionEnabledToNSPanel(boolean allowMultipleSelection) {
        if (this._dialog != null && this._mode == 0) {
            NSAutoreleasePool autoreleasePool = null;
            if (this.isRequireExplicitCleanup()) {
                autoreleasePool = NSAutoreleasePool.alloc();
                autoreleasePool.init();
            }
            ((NSOpenPanel)this.getDialog()).setAllowsMultipleSelection(allowMultipleSelection);
            if (autoreleasePool != null && this.isRequireExplicitCleanup()) {
                autoreleasePool.drain();
            }
        }
    }

    public void setAllowMultipleSelection(boolean value) {
        if (this._mode == 0) {
            this._allowMultipleSelection = value;
            this.invokeInAwtThread(new Runnable(){

                public void run() {
                    AbstractChooseField.this.setMultipleSelectionEnabledToNSPanel(AbstractChooseField.this._allowMultipleSelection);
                }
            });
        }
    }

    public boolean isAllowInvisibleFiles() {
        return this._allowInvisibleFiles;
    }

    private void setAllowInvisibleFilesToNSPanel(boolean allowInvisibleFiles) {
        if (this._dialog != null) {
            NSAutoreleasePool autoreleasePool = null;
            if (this.isRequireExplicitCleanup()) {
                autoreleasePool = NSAutoreleasePool.alloc();
                autoreleasePool.init();
            }
            this.getDialog().setCanSelectHiddenExtension(allowInvisibleFiles);
            if (autoreleasePool != null && this.isRequireExplicitCleanup()) {
                autoreleasePool.drain();
            }
        }
    }

    public void setAllowInvisibleFiles(boolean value) {
        this._allowInvisibleFiles = value;
        this.invokeInAwtThread(new Runnable(){

            public void run() {
                AbstractChooseField.this.setAllowInvisibleFilesToNSPanel(AbstractChooseField.this._allowInvisibleFiles);
            }
        });
    }

    public boolean isTreatsFilePackagesAsDirectories() {
        return this._treatsFilePackagesAsDirectories;
    }

    private void setTreatsFilePackagesAsDirectoriesToNSPanel(boolean treatsFilePackagesAsDirectories) {
        if (this._dialog != null) {
            NSAutoreleasePool autoreleasePool = null;
            if (this.isRequireExplicitCleanup()) {
                autoreleasePool = NSAutoreleasePool.alloc();
                autoreleasePool.init();
            }
            this.getDialog().setTreatsFilePackagesAsDirectories(treatsFilePackagesAsDirectories);
            if (autoreleasePool != null && this.isRequireExplicitCleanup()) {
                autoreleasePool.drain();
            }
        }
    }

    public void setTreatsFilePackagesAsDirectories(boolean value) {
        this._treatsFilePackagesAsDirectories = value;
        this.invokeInAwtThread(new Runnable(){

            public void run() {
                AbstractChooseField.this.setTreatsFilePackagesAsDirectoriesToNSPanel(AbstractChooseField.this._treatsFilePackagesAsDirectories);
            }
        });
    }

    public boolean isAllowCreateDirectories() {
        return this._allowCreateDirectories;
    }

    private void setCanCreateDirectoriesToNSPanel(boolean allowCreateDirectories) {
        if (this._dialog != null) {
            NSAutoreleasePool autoreleasePool = null;
            if (this.isRequireExplicitCleanup()) {
                autoreleasePool = NSAutoreleasePool.alloc();
                autoreleasePool.init();
            }
            this.getDialog().setCanCreateDirectories(allowCreateDirectories);
            if (autoreleasePool != null && this.isRequireExplicitCleanup()) {
                autoreleasePool.drain();
            }
        }
    }

    public void setAllowCreateDirectories(boolean value) {
        this._allowCreateDirectories = value;
        this.invokeInAwtThread(new Runnable(){

            public void run() {
                AbstractChooseField.this.setCanCreateDirectoriesToNSPanel(AbstractChooseField.this._allowCreateDirectories);
            }
        });
    }

    protected void setMode(int mode) {
        if (mode == 0 || mode == 1) {
            if (this._mode != mode && !this.isDialogShowing()) {
                this.dumpDialog();
                this._mode = mode;
            }
        } else {
            throw new IllegalArgumentException("This implementation of dialog supports only SelectFileField.MODE_SAVE_FILE and SelectFileField.MODE_OPEN_FILE types");
        }
    }

    private void invokeInAwtThread(Runnable action) {
        if (this._dialog != null) {
            AwtMacMessageLoop.getInstance().invokeAndWait(action);
        }
    }

    protected void dumpDialog() {
        if (this._dialog != null && this.isRequireExplicitCleanup()) {
            this._dialog.release();
        }
        this._dialog = null;
    }

    protected void refreshFiles() {
        this._files.clear();
        NSAutoreleasePool autoreleasePool = null;
        if (this.isRequireExplicitCleanup()) {
            autoreleasePool = NSAutoreleasePool.alloc();
            autoreleasePool.init();
        }
        if (this._mode == 0) {
            if (MINOR_OS_VERSION < 6) {
                NSArray files = new NSArray(((NSOpenPanel)this.getDialog()).filenames());
                long filesCount = files.count().getValue();
                int i = 0;
                while ((long)i < filesCount) {
                    NSString folderName = new NSString(files.objectAtIndex(new UInt16(i)));
                    this._files.add(new File(folderName.cString().getValue()));
                    ++i;
                }
            } else {
                Pointer.Void pointerToArrayOfURLs = ((NSOpenPanel)this.getDialog()).URLs();
                NSArray arrayOfURLs = new NSArray(pointerToArrayOfURLs);
                long urlsCount = arrayOfURLs.count().getValue();
                int i = 0;
                while ((long)i < urlsCount) {
                    Id pointerToURL = arrayOfURLs.objectAtIndex(new UInt16(i));
                    File fileFromNsUrl = this.getFileFromNsUrl(pointerToURL);
                    if (fileFromNsUrl != null) {
                        this._files.add(fileFromNsUrl);
                    }
                    ++i;
                }
            }
        } else if (MINOR_OS_VERSION < 6) {
            Pointer.Void pointerToFileName = this.getDialog().filename();
            File fileFromNsString = this.getFileFromNsString(pointerToFileName);
            if (fileFromNsString != null) {
                this._files.add(fileFromNsString);
            }
        } else {
            Pointer.Void pointerToFileUrl = this.getDialog().URL();
            File fileFromNsUrl = this.getFileFromNsUrl(pointerToFileUrl);
            if (fileFromNsUrl != null) {
                this._files.add(fileFromNsUrl);
            }
        }
        if (autoreleasePool != null && this.isRequireExplicitCleanup()) {
            autoreleasePool.drain();
        }
    }

    private File getFileFromNsString(Pointer.Void pointerToDirectoryName) {
        File result = null;
        NSString directoryNameNsString = new NSString(pointerToDirectoryName);
        String directoryName = directoryNameNsString.cString().getValue();
        if (directoryName.length() != 0) {
            result = new File(directoryName);
        }
        return result;
    }

    private File getFileFromNsUrl(Pointer.Void pointerToURL) {
        String parsedDirectoryPath;
        File result = null;
        NSURL url = new NSURL(pointerToURL);
        Pointer.Void pointerToStringURL = url.absoluteString();
        NSString nsStringURL = new NSString(pointerToStringURL);
        String directoryPath = nsStringURL.cString().getValue();
        try {
            URI uri = new URI(directoryPath);
            parsedDirectoryPath = uri.getPath();
        }
        catch (URISyntaxException e) {
            throw new NullPointerException("Cannot retrieve directory information");
        }
        if (parsedDirectoryPath.length() != 0) {
            result = new File(parsedDirectoryPath);
        }
        return result;
    }

    protected void passDialogParametersToNSPanel() {
        this.getDialog();
        this.setMultipleSelectionEnabledToNSPanel(this._allowMultipleSelection);
        this.setCanCreateDirectoriesToNSPanel(this._allowCreateDirectories);
        this.setAllowInvisibleFilesToNSPanel(this._allowInvisibleFiles);
        this.setTreatsFilePackagesAsDirectoriesToNSPanel(this._treatsFilePackagesAsDirectories);
    }

    protected NSSavePanel getDialog() {
        if (this._dialog == null) {
            NSAutoreleasePool autoreleasePool = null;
            if (this.isRequireExplicitCleanup()) {
                autoreleasePool = NSAutoreleasePool.alloc();
                autoreleasePool.init();
            }
            switch (this._mode) {
                case 0: {
                    this._dialog = new NSOpenPanel();
                    break;
                }
                case 1: {
                    this._dialog = new NSSavePanel();
                }
            }
            this._dialog.retain();
            if (autoreleasePool != null && this.isRequireExplicitCleanup()) {
                autoreleasePool.drain();
            }
        }
        return this._dialog;
    }

    protected boolean isRequireExplicitCleanup() {
        return !AwtMacMessageLoop.getInstance().isEventDispatchThread();
    }

    static {
        String osVersion = System.getProperty("os.version");
        StringTokenizer stringTokenizer = new StringTokenizer(osVersion, ".");
        stringTokenizer.nextToken();
        String minorVersion = stringTokenizer.nextToken();
        MINOR_OS_VERSION = Integer.parseInt(minorVersion);
    }
}

