/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.macosx.cocoa;

import com.jniwrapper.Callback;
import com.jniwrapper.FunctionExecutionException;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.macosx.cocoa.CClass;
import com.jniwrapper.macosx.cocoa.CocoaLib;
import com.jniwrapper.macosx.cocoa.Id;
import com.jniwrapper.macosx.cocoa.Imp;
import com.jniwrapper.macosx.cocoa.Sel;

public abstract class Method
extends Callback {
    private CClass _cclass = null;
    private Sel _sel = null;
    private Pointer.Void _methodInfo = null;
    private Imp _original = null;
    private Id _paramiId = new Id();
    private Sel _paramSel = new Sel();

    private Method() {
        super(null, null);
    }

    protected Method(CClass cclass) {
        this();
        this._cclass = cclass;
    }

    public Method(CClass cclass, Sel sel, Parameter[] params, Parameter retVal) {
        this();
        this._cclass = cclass;
        this.init(sel, params, retVal);
    }

    protected final void init(Sel sel, Parameter[] params, Parameter retVal) {
        this._sel = sel;
        this.init(CocoaLib.createInvokeParameters((Parameter)this._paramiId, this._paramSel, params), retVal);
        Pointer.Void methodInfo = CocoaLib.classGetInstanceMethod(this._cclass, this._sel);
        if (!methodInfo.isNull()) {
            this._methodInfo = methodInfo;
            this._original = CocoaLib.methogGetImplementation(this._methodInfo);
        }
    }

    protected Id getId() {
        return this._paramiId;
    }

    protected Sel getSel() {
        return this._paramSel;
    }

    public void register() {
        CocoaLib.methodSetImplementation(this._methodInfo, this.toPointer());
    }

    public void unregister() {
        CocoaLib.methodSetImplementation(this._methodInfo, this._original);
    }

    protected final void invokeOriginal(Parameter returnValue, Parameter[] parameters) throws FunctionExecutionException {
        this._original.asFunction().invoke(returnValue, CocoaLib.createInvokeParameters((Parameter)this._paramiId, this._paramSel, parameters));
    }
}

