/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.macosx.cocoa;

import com.jniwrapper.AnsiString;
import com.jniwrapper.ExternalStringPointer;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Library;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Structure;
import com.jniwrapper.Union;
import com.jniwrapper.macosx.cocoa.CClass;
import com.jniwrapper.macosx.cocoa.Id;
import com.jniwrapper.macosx.cocoa.Imp;
import com.jniwrapper.macosx.cocoa.Method;
import com.jniwrapper.macosx.cocoa.Sel;
import com.jniwrapper.macosx.cocoa.nsobject.NSObject;
import java.util.HashMap;
import java.util.Map;

class CocoaLib {
    private static Map _uid2IDMap = new HashMap();
    private static Function _getClass;
    private static Function _getUID;
    private static Function _regUID;
    private static Function _getName;
    private static Function _msgSend;
    private static Function _msgSendStret;
    private static Function _classGetInstanceMethod;
    private static Function _methodGetImplementation;
    private static Function _methodSetImplementation;
    private static Function _methodGetArgCount;
    private static Function _methodGetRetType;
    private static Function _methodGetArgType;

    CocoaLib() {
    }

    static CClass getClass(String name) {
        CClass result = new CClass(name);
        _getClass.invoke((Parameter)result, (Parameter)new AnsiString(name));
        return result;
    }

    static void getClass(CClass cclass) {
        if (cclass.getValue() == 0L) {
            _getClass.invoke((Parameter)cclass, (Parameter)new AnsiString(cclass.getName()));
        }
    }

    static Id selGetUID(String name) {
        Id result = (Id)((Object)_uid2IDMap.get(name));
        if (result == null) {
            result = new Id();
            _getUID.invoke((Parameter)result, (Parameter)new AnsiString(name));
            _uid2IDMap.put(name, result);
        }
        return result;
    }

    static Id selRegisterUID(String name) {
        Id result = (Id)((Object)_uid2IDMap.get(name));
        if (result == null) {
            result = new Id();
            _regUID.invoke((Parameter)result, (Parameter)new AnsiString(name));
            _uid2IDMap.put(name, result);
        }
        return result;
    }

    static String selGetName(Sel sel) {
        ExternalStringPointer result = new ExternalStringPointer();
        _getName.invoke((Parameter)result, (Parameter)sel);
        return result.readString();
    }

    static Parameter msgSend(Parameter id, Sel sel, Class returnType, Object[] parameters) {
        Parameter result = null;
        if (id instanceof CClass) {
            CocoaLib.getClass((CClass)id);
        }
        if (returnType != null && ((result = CocoaLib.createParameter(returnType)) instanceof Structure || result instanceof Union)) {
            _msgSendStret.invoke(result, CocoaLib.createInvokeParameters(id, sel, parameters));
            return result;
        }
        _msgSend.invoke(result, CocoaLib.createInvokeParameters(id, sel, parameters));
        return result;
    }

    static Pointer.Void classGetInstanceMethod(CClass cclass, Sel sel) {
        Pointer.Void result = new Pointer.Void();
        _classGetInstanceMethod.invoke((Parameter)result, (Parameter)cclass, (Parameter)sel);
        return result;
    }

    static Imp methogGetImplementation(Pointer.Void methodInfo) {
        Imp result = new Imp();
        _methodGetImplementation.invoke((Parameter)result, (Parameter)methodInfo);
        return result;
    }

    static Imp methodSetImplementation(Pointer.Void methodInfo, Pointer.Void imp) {
        Imp result = new Imp();
        _methodSetImplementation.invoke((Parameter)result, (Parameter)methodInfo, (Parameter)imp);
        return result;
    }

    static Parameter createParameter(Class parameterType) {
        try {
            Object result = parameterType.newInstance();
            return (Parameter)result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static Parameter[] createInvokeParameters(Parameter classID, Sel sel, Object[] parameters) {
        Parameter[] invokeParameters;
        int parametersCount = parameters.length;
        if (parametersCount > 0 && parameters[parametersCount - 1] instanceof Parameter[]) {
            Parameter[] additionalParameters = (Parameter[])parameters[parametersCount - 1];
            invokeParameters = new Parameter[parametersCount + additionalParameters.length + 1];
            int i = 0;
            int j = parametersCount;
            while (i < additionalParameters.length) {
                invokeParameters[j] = additionalParameters[i];
                ++i;
                ++j;
            }
            --parametersCount;
        } else {
            invokeParameters = new Parameter[parametersCount + 2];
        }
        invokeParameters[0] = classID;
        invokeParameters[1] = sel;
        for (int i = 0; i < parametersCount; ++i) {
            invokeParameters[2 + i] = (Parameter)parameters[i];
        }
        return invokeParameters;
    }

    public static void main(String[] args) {
        Library jni = new Library("jniwrap");
        Test test = new Test();
        System.err.println("Original:");
        test.m1(1);
        test.m2();
        MyMethod m = new MyMethod(Test.CLASSID, new Sel("m1:"));
        m.register();
        System.err.println("Modified:");
        test.m1(1);
        test.m2();
        m.unregister();
        System.err.println("Original:");
        test.m1(1);
        test.m2();
    }

    static {
        Library.ensureNativeCode();
        Library lib = new Library("libobjc.dylib");
        _getClass = lib.getFunction("objc_getClass");
        _getUID = lib.getFunction("sel_getUid");
        _regUID = lib.getFunction("sel_registerName");
        _getName = lib.getFunction("sel_getName");
        _msgSend = lib.getFunction("objc_msgSend");
        _msgSendStret = lib.getFunction("objc_msgSend_stret");
        _classGetInstanceMethod = lib.getFunction("class_getInstanceMethod");
        _methodGetImplementation = lib.getFunction("method_getImplementation");
        _methodSetImplementation = lib.getFunction("method_setImplementation");
        _methodGetArgCount = lib.getFunction("method_getNumberOfArguments");
        _methodGetRetType = lib.getFunction("method_copyReturnType");
        _methodGetArgType = lib.getFunction("method_copyArgumentType");
    }

    static class MyMethod
    extends Method {
        private Int _val = new Int();

        public MyMethod(CClass cclass, Sel sel) {
            super(cclass);
            this.init(sel, new Parameter[]{this._val}, null);
        }

        public void callback() {
            System.err.println("MyMethod");
            this.invokeOriginal(null, new Parameter[]{this._val});
        }
    }

    static class Test
    extends NSObject {
        static final CClass CLASSID = new CClass("Test");

        public void m1(int val) {
            Sel.getFunction("m1:").invoke((Id)this, new Object[]{new Int((long)val)});
        }

        public void m2() {
            Sel.getFunction("m2").invoke((Id)this, new Object[0]);
        }
    }
}

