/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.macosx.accessibility;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.macosx.accessibility.AXError;
import com.jniwrapper.macosx.accessibility.AXException;
import com.jniwrapper.macosx.accessibility.AXUIElementRef;
import com.jniwrapper.macosx.cocoa.mactypes.Float32;
import com.jniwrapper.macosx.corefoundation.CFArray;
import com.jniwrapper.macosx.corefoundation.CFArrayRef;
import com.jniwrapper.macosx.framework.ApplicationServices;
import java.awt.Point;

public class AXUIElement {
    private static AXUIElement _instance;
    private static final String API_ENABLED_FUNCTION = "AXAPIEnabled";
    private static final String IS_PROCESS_TRUSTED_FUNCTION = "AXIsProcessTrusted";
    private static final String MAKE_PROCESS_TRUSTED_FUNCTION = "AXMakeProcessTrusted";
    private static final String CREATE_SYSTEM_WIDE_FUNCTION = "AXUIElementCreateSystemWide";
    private static final String COPY_ELEMENT_AT_POSITION_FUNCTION = "AXUIElementCopyElementAtPosition";
    private static final String COPY_ACTION_NAMES_FUNCTION = "AXUIElementCopyActionNames";
    private static final String COPY_ATTRIBUTE_NAMES_FUNCTION = "AXUIElementCopyAttributeNames";
    private static final String COPY_ATTRIBUTE_VALUE_FUNCTION = "AXUIElementCopyAttributeValue";
    private static final String COPY_ATTRIBUTE_VALUES_FUNCTION = "AXUIElementCopyAttributeValues";
    private static final String COPY_ATTRIBUTE_VALUE_COUNT_FUNCTION = "AXUIElementGetAttributeValueCount";
    private static final String IS_ATTRIBUTE_SETTABLE_FUNCTION = "AXUIElementIsAttributeSettable";

    public static AXUIElement getInstance() {
        return _instance == null ? (_instance = new AXUIElement()) : _instance;
    }

    private AXUIElement() {
    }

    private Function getFunction(String functionName) {
        return ApplicationServices.getInstance().getFunction(functionName);
    }

    public boolean isAPIEnabled() {
        Function function = this.getFunction(API_ENABLED_FUNCTION);
        Bool returnValue = new Bool();
        function.invoke((Parameter)returnValue);
        return returnValue.getValue();
    }

    public boolean isCurrentProcessTrusted() {
        Function function = this.getFunction(IS_PROCESS_TRUSTED_FUNCTION);
        Bool returnValue = new Bool();
        function.invoke((Parameter)returnValue);
        return returnValue.getValue();
    }

    public void makeProcessTrusted(String executablePath) {
        Function function = this.getFunction(MAKE_PROCESS_TRUSTED_FUNCTION);
        AXError error = new AXError();
        function.invoke((Parameter)error, (Parameter)new Str(executablePath));
        AXException.checkResult(error);
    }

    public AXUIElementRef createSystemWide() {
        Function function = this.getFunction(CREATE_SYSTEM_WIDE_FUNCTION);
        AXUIElementRef application = new AXUIElementRef();
        function.invoke((Parameter)application);
        return application;
    }

    public AXUIElementRef copyElementAtPosition(AXUIElementRef application, Point position) {
        Function function = this.getFunction(COPY_ELEMENT_AT_POSITION_FUNCTION);
        AXError error = new AXError();
        AXUIElementRef element = new AXUIElementRef();
        function.invoke((Parameter)error, (Parameter)application, (Parameter)new Float32(position.x), (Parameter)new Float32(position.y), (Parameter)new Pointer((Parameter)element));
        AXException.checkResult(error);
        return element;
    }

    public String[] copyActionNames(AXUIElementRef element) {
        Function function = this.getFunction(COPY_ACTION_NAMES_FUNCTION);
        AXError error = new AXError();
        CFArrayRef arrayRef = new CFArrayRef();
        function.invoke((Parameter)error, (Parameter)element, (Parameter)new Pointer((Parameter)arrayRef));
        AXException.checkResult(error);
        CFArray array = new CFArray(arrayRef);
        int count = array.getCount();
        System.out.println("count = " + count);
        return new String[0];
    }

    public String[] copyAttributeNames(AXUIElementRef element) {
        Function function = this.getFunction(COPY_ATTRIBUTE_NAMES_FUNCTION);
        AXError error = new AXError();
        CFArrayRef arrayRef = new CFArrayRef();
        function.invoke((Parameter)error, (Parameter)element, (Parameter)new Pointer((Parameter)arrayRef));
        AXException.checkResult(error);
        CFArray array = new CFArray(arrayRef);
        int count = array.getCount();
        System.out.println("count = " + count);
        return new String[0];
    }

    public Object copyAttributeValue(AXUIElementRef element, String attribute) {
        return null;
    }

    public Object[] copyAttributeValues(AXUIElementRef element, String attribute, int index, int maxValues) {
        return null;
    }

    public int getAttributeValueCount(AXUIElementRef element, String attribute) {
        return 0;
    }

    public boolean isAttributeSettable(AXUIElementRef element, String attribute) {
        return false;
    }
}

