/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui.dialogs;

import com.jniwrapper.Callback;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.HResult;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.IntPtr;
import com.jniwrapper.win32.automation.types.BStr;
import com.jniwrapper.win32.shell.Shell32;
import com.jniwrapper.win32.shell.ShellFolder;
import com.jniwrapper.win32.shell.impl.IShellFolderImpl;
import com.jniwrapper.win32.system.VersionInfo;
import com.jniwrapper.win32.ui.Wnd;
import com.jniwrapper.win32.ui.dialogs.BIStructure;
import com.jniwrapper.win32.ui.dialogs.DialogHelper;
import java.awt.Window;
import java.io.File;

public class SelectFolderDialog {
    static final FunctionName FUNCTION_BROWSE_FOR_FOLDER = new FunctionName("SHBrowseForFolder");
    static final String FUNCTION_GET_DESKTOP_FOLDER = "SHGetDesktopFolder";
    private ShellFolder _startFolder = ShellFolder.DESKTOP;
    private Window _owner = null;
    private Wnd _ownerWnd = null;
    private String _title = "";
    private String _folder = "";
    private String _rootFolder = null;
    private SelectFolderDialogOptions _flags = new SelectFolderDialogOptions();

    public SelectFolderDialog() {
        this.reset();
    }

    public SelectFolderDialog(String title) {
        this();
        this.setTitle(title);
    }

    public SelectFolderDialog(String rootFolder, String title) {
        this();
        this.setTitle(title);
        this._rootFolder = rootFolder;
    }

    public SelectFolderDialog(Window owner) {
        this.setOwner(owner);
        this.reset();
    }

    public SelectFolderDialog(Window owner, File rootFolder) {
        this.setOwner(owner);
        this.reset();
        this._rootFolder = rootFolder.getAbsolutePath();
    }

    public SelectFolderDialog(Window owner, String title) {
        this(owner);
        this.setTitle(title);
    }

    public SelectFolderDialog(Window owner, String rootFolder, String title) {
        this(owner, title);
        this._rootFolder = rootFolder;
    }

    public SelectFolderDialog(Wnd owner, File rootFolder, String title) {
        this.setOwnerWnd(owner);
        if (rootFolder == null) {
            throw new IllegalArgumentException();
        }
        this._rootFolder = rootFolder.getAbsolutePath();
        this._title = title;
        this.reset();
    }

    public SelectFolderDialog(Wnd owner, File rootFolder) {
        this.setOwnerWnd(owner);
        this._rootFolder = rootFolder.getAbsolutePath();
        this.reset();
    }

    public SelectFolderDialog(Wnd owner, String title) {
        this.setOwnerWnd(owner);
        this._title = title;
        this.reset();
    }

    public SelectFolderDialog(Wnd owner) {
        this.setOwnerWnd(owner);
        this.reset();
    }

    protected void reset() {
        this._flags.clear();
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getFolder() {
        return this._folder;
    }

    public void setFolder(String folder) {
        this._folder = folder;
    }

    public Window getOwner() {
        return this._owner;
    }

    public void setOwner(Window owner) {
        this._owner = owner;
        this._ownerWnd = new Wnd(owner);
    }

    public void setOwnerWnd(Wnd ownerWnd) {
        this._ownerWnd = ownerWnd;
    }

    public Wnd getOwnerWnd() {
        return this._ownerWnd;
    }

    public SelectFolderDialogOptions getOptions() {
        return this._flags;
    }

    public ShellFolder getStartFolder() {
        return this._startFolder;
    }

    public void setStartFolder(ShellFolder startFolder) {
        this._startFolder = startFolder;
    }

    public boolean execute() {
        boolean result;
        Wnd owner = this._owner != null ? this._ownerWnd : (this._ownerWnd == null ? new Wnd() : this._ownerWnd);
        Shell32 shell32 = Shell32.getInstance();
        Handle root = null;
        if (this._rootFolder != null) {
            Pointer rootPointer = new Pointer((Parameter)new Pointer.Void());
            IShellFolderImpl desktopFolder = new IShellFolderImpl();
            Function getDesktopFolder = shell32.getFunction(FUNCTION_GET_DESKTOP_FOLDER);
            HResult result2 = new HResult();
            getDesktopFolder.invoke((Parameter)result2, (Parameter)new Pointer((Parameter)desktopFolder));
            if (result2.getValue() != 0L) {
                return false;
            }
            desktopFolder.parseDisplayName(new Wnd(), null, new BStr(this._rootFolder), new UInt32(), rootPointer, new UInt32());
            if (rootPointer.isNull()) {
                return false;
            }
            root = rootPointer;
        } else {
            int folderID = this._startFolder.getFolderID();
            root = ShellFolder.getFolderIDList(folderID);
            if (root.isNull()) {
                return false;
            }
        }
        DialogCallback dialogCallback = null;
        File directory = new File(this._folder);
        if (!directory.exists()) {
            this._folder = "";
        }
        Str selectedDir = null;
        if (this._folder.length() > 0) {
            selectedDir = new Str(this._folder);
            dialogCallback = new DialogCallback();
        }
        BIStructure browseInfoStructure = new BIStructure((Parameter)dialogCallback, (Parameter)root);
        browseInfoStructure.setOwner(owner);
        browseInfoStructure.setTitle(this.getTitle());
        browseInfoStructure.setFlags(this._flags.getFlags());
        if (selectedDir != null) {
            browseInfoStructure.setParam((Parameter)selectedDir);
        }
        Function browseForFolder = shell32.getFunction(FUNCTION_BROWSE_FOR_FOLDER.toString());
        Handle returnValue = new Handle();
        if (this._owner != null) {
            DialogHelper.invokeDialog(this._owner, browseForFolder, (Parameter)returnValue, new Parameter[]{new Pointer((Parameter)browseInfoStructure)});
        } else {
            browseForFolder.invoke((Parameter)returnValue, (Parameter)new Pointer((Parameter)browseInfoStructure));
        }
        if (returnValue.isNull()) {
            return false;
        }
        boolean bl = result = !returnValue.isNull();
        if (result) {
            String selectedFolder = ShellFolder.getPathFromIDList(returnValue);
            this._folder = selectedFolder.length() == 0 && this._flags.contains(4096L) ? "\\\\" + browseInfoStructure.getDisplayName() : selectedFolder;
        }
        return result;
    }

    public static SelectFolderDialog createBrowseForComputersDialog() {
        SelectFolderDialog dialog = new SelectFolderDialog();
        SelectFolderDialogOptions flags = dialog.getOptions();
        flags.clear();
        flags.add(64L);
        flags.add(512L);
        flags.add(4096L);
        dialog.setStartFolder(ShellFolder.NETWORK);
        return dialog;
    }

    public static SelectFolderDialog createBrowseForPrintersDialog() {
        SelectFolderDialog dialog = new SelectFolderDialog();
        SelectFolderDialogOptions flags = dialog.getOptions();
        flags.clear();
        VersionInfo versionInfo = new VersionInfo();
        if (!versionInfo.isWin2k()) {
            flags.add(64L);
        }
        flags.add(8704L);
        dialog.setStartFolder(ShellFolder.NETWORK);
        return dialog;
    }

    public class SelectFolderDialogOptions
    extends FlagSet {
        public static final int RETURNONLYFSDIRS = 1;
        public static final int DONTGOBELOWDOMAIN = 2;
        public static final int STATUSTEXT = 4;
        public static final int RETURNFSANCESTORS = 8;
        public static final int EDITBOX = 16;
        public static final int VALIDATE = 32;
        public static final int NEWDIALOGSTYLE = 64;
        public static final int BROWSEINCLUDEURLS = 128;
        public static final int BROWSEFORCOMPUTER = 4096;
        public static final int BROWSEFORPRINTER = 8192;
        public static final int BROWSEINCLUDEFILES = 16384;
        public static final int SHAREABLE = 32768;
        public static final int NONEWFOLDERBUTTON = 512;

        public SelectFolderDialogOptions() {
            this.reset();
        }

        public void reset() {
            this.clear();
            this.add(67L);
        }

        public boolean isOnlyFilesystem() {
            return this.contains(1L);
        }

        public void setOnlyFileSystem(boolean onlyFileSystem) {
            if (onlyFileSystem) {
                this.add(1L);
            } else {
                this.remove(1L);
            }
        }

        public boolean isNewDialogStyle() {
            return this.contains(64L);
        }

        public void setNewDialogStyle(boolean newDialogStyle) {
            if (newDialogStyle) {
                this.add(64L);
            } else {
                this.remove(64L);
            }
        }

        public boolean isSelectFiles() {
            return this.contains(16384L);
        }

        public void setSelectFiles(boolean selectFiles) {
            if (selectFiles) {
                this.add(16384L);
            } else {
                this.remove(16384L);
            }
        }

        public boolean isShowTextBox() {
            return this.contains(16L);
        }

        public void setShowTextBox(boolean showTextBox) {
            if (showTextBox) {
                this.add(16L);
            } else {
                this.remove(16L);
            }
        }

        public boolean isShowNewFolderButton() {
            return !this.contains(512L);
        }

        public void setShowNewFolderButton(boolean showNewFolderButton) {
            if (showNewFolderButton) {
                this.remove(512L);
            } else {
                this.add(512L);
            }
        }

        public boolean isShowNetworkFolders() {
            return !this.contains(2L);
        }

        public void setShowNetworkFolders(boolean showNetworkFolders) {
            if (showNetworkFolders) {
                this.remove(2L);
            } else {
                this.add(2L);
            }
        }

        public boolean isShowFiles() {
            return this.contains(16384L);
        }

        public void setShowFiles(boolean showFiles) {
            if (showFiles) {
                this.add(16384L);
            } else {
                this.remove(16384L);
            }
        }
    }

    private static class DialogCallback
    extends Callback {
        private Wnd _wnd = new Wnd();
        private UInt32 _msg = new UInt32();
        private IntPtr _lParam = new IntPtr();
        private UInt32 _data = new UInt32();
        private Int _retValue = new Int();
        static final int BFFM_INITIALIZED = 1;
        static final int BFFM_SETSELECTIONA = 1126;
        static final int BFFM_SETSELECTIONW = 1127;
        static final int BFFM_SETSELECTION = PlatformContext.isUnicode() ? 1127 : 1126;

        public DialogCallback() {
            this.init(new Parameter[]{this._wnd, this._msg, this._lParam, this._data}, (Parameter)this._retValue);
        }

        public void callback() {
            long message = this._msg.getValue();
            long value = this._data.getValue();
            if (message == 1L && value != 0L) {
                this._wnd.sendMessageEx(BFFM_SETSELECTION, 1L, value);
            }
            this._retValue.setValue(0L);
        }
    }
}

