/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui.dialogs;

import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.ui.WindowMessage;
import com.jniwrapper.win32.ui.WindowMessageListener;
import com.jniwrapper.win32.ui.WindowProc;
import com.jniwrapper.win32.ui.Wnd;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;

public class DialogHelper {
    private static final Logger LOG = Logger.getInstance((Class)DialogHelper.class);
    private static boolean EnableFramePainterFix;

    private DialogHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeDialog(Window owner, Function function, Parameter returnValue, Parameter[] parameters) {
        ArrayList<WindowProc> windowProcedures = Collections.EMPTY_LIST;
        if (EnableFramePainterFix) {
            ArrayList<Frame> frames = new ArrayList<Frame>(Arrays.asList(Frame.getFrames()));
            if (!frames.contains(owner)) {
                frames.add((Frame)owner);
            }
            windowProcedures = new ArrayList<WindowProc>(frames.size());
            Iterator i = frames.iterator();
            while (i.hasNext()) {
                Window window = (Window)i.next();
                Wnd wnd = new Wnd(window);
                if (wnd.getValue() == 0L) continue;
                WindowProc windowProc = new WindowProc(wnd);
                FramePainter framePainter = new FramePainter(window);
                windowProc.addMessageListener(framePainter);
                windowProc.substitute();
                windowProcedures.add(windowProc);
            }
        }
        try {
            function.invoke(returnValue, parameters);
        }
        finally {
            if (EnableFramePainterFix) {
                Iterator i = windowProcedures.iterator();
                while (i.hasNext()) {
                    WindowProc windowProcedure = (WindowProc)((Object)i.next());
                    windowProcedure.restoreNative();
                }
            }
        }
    }

    static {
        try {
            String version = System.getProperty("java.runtime.version");
            EnableFramePainterFix = version == null || version.startsWith("1.4") || version.startsWith("1.3");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class FramePainter
    implements WindowMessageListener {
        private Window _window;

        public FramePainter(Window window) {
            this._window = window;
        }

        public boolean canHandle(WindowMessage message, boolean beforeWindowProc) {
            return !beforeWindowProc && message.getMsg() == 15;
        }

        public int handle(WindowMessage message) {
            this._window.paint(this._window.getGraphics());
            return 0;
        }
    }
}

