/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt64;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.system.Kernel32;

public class MemoryStatusEx
extends Structure {
    static final String FUNCTION_GET_MEMORY_STATUS_EX = "GlobalMemoryStatusEx";
    private UInt32 _length = new UInt32();
    private UInt32 _memoryLoad = new UInt32();
    private UInt64 _totalPhys = new UInt64();
    private UInt64 _availPhys = new UInt64();
    private UInt64 _totalPageFile = new UInt64();
    private UInt64 _availPageFile = new UInt64();
    private UInt64 _totalVirtual = new UInt64();
    private UInt64 _availVirtual = new UInt64();
    private UInt64 _availExtendedVirtual = new UInt64();

    public MemoryStatusEx() {
        this.init(new Parameter[]{this._length, this._memoryLoad, this._totalPhys, this._availPhys, this._totalPageFile, this._availPageFile, this._totalVirtual, this._availVirtual, this._availExtendedVirtual});
        this._length.setValue((long)this.getLength());
        Function globalMemoryStatus = Kernel32.getInstance().getFunction(FUNCTION_GET_MEMORY_STATUS_EX);
        Bool result = new Bool();
        long errorCode = globalMemoryStatus.invoke((Parameter)result, (Parameter)new Pointer((Parameter)this));
        if (!result.getValue()) {
            throw new LastErrorException(errorCode);
        }
    }

    public MemoryStatusEx(MemoryStatusEx that) {
        this();
        this.initFrom(that);
    }

    public long getMemoryLoad() {
        return this._memoryLoad.getValue();
    }

    public long getTotalPhys() {
        return this._totalPhys.getValue();
    }

    public long getAvailPhys() {
        return this._availPhys.getValue();
    }

    public long getTotalPageFile() {
        return this._totalPageFile.getValue();
    }

    public long getAvailPageFile() {
        return this._availPageFile.getValue();
    }

    public long getTotalVirtual() {
        return this._totalVirtual.getValue();
    }

    public long getAvailVirtual() {
        return this._availVirtual.getValue();
    }

    public long getAvailExtendedVirtual() {
        return this._availExtendedVirtual.getValue();
    }

    public Object clone() {
        MemoryStatusEx clone = new MemoryStatusEx();
        clone.initFrom(this);
        return clone;
    }
}

