/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.UInt;
import com.jniwrapper.ULongInt;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.system.Kernel32;
import com.jniwrapper.win32.system.MemoryAllocationAttributes;

public class LocalMemoryBlock
extends Handle {
    private static final String FUNCTION_LocalAlloc = "LocalAlloc";
    private static final String FUNCTION_LocalFree = "LocalFree";
    private static final String FUNCTION_LocalSize = "LocalSize";
    private static final String FUNCTION_LocalLock = "LocalLock";
    private static final String FUNCTION_LocalUnlock = "LocalUnlock";

    public LocalMemoryBlock() {
    }

    public LocalMemoryBlock(Handle handle) {
        super(handle.getValue());
    }

    public LocalMemoryBlock(int size, MemoryAllocationAttributes attributes) {
        this.alloc(size, attributes);
    }

    public void free() {
        LocalMemoryBlock.localFree((Parameter)this);
    }

    public static void localFree(Parameter localMemoryBlock) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_LocalFree);
        LocalMemoryBlock result = new LocalMemoryBlock();
        function.invoke((Parameter)result, localMemoryBlock);
        if (!result.isNull()) {
            throw new RuntimeException("Can't free local memory block.");
        }
    }

    private void alloc(long numBytes, MemoryAllocationAttributes attributes) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_LocalAlloc);
        function.invoke((Parameter)this, new Parameter[]{new UInt((long)attributes.getValue()), new ULongInt(numBytes)});
    }

    public int size() {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_LocalSize);
        UInt result = new UInt();
        function.invoke((Parameter)result, (Parameter)this);
        return (int)result.getValue();
    }

    public Handle lock() {
        Handle result = new Handle();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_LocalLock);
        function.invoke((Parameter)result, (Parameter)this);
        return result;
    }

    public int unlock() {
        Int result = new Int();
        Function function = Kernel32.getInstance().getFunction(FUNCTION_LocalUnlock);
        function.invoke((Parameter)result, (Parameter)this);
        return (int)result.getValue();
    }
}

