/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell;

import com.jniwrapper.Int;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt32;
import com.jniwrapper.WideString;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.Enums;
import com.jniwrapper.win32.shell.ComponentLocation;
import java.net.MalformedURLException;
import java.net.URL;

public class ActiveDesktopItem
extends Structure {
    private static final int MAX_PATH = 260;
    private static final int INTERNET_MAX_SCHEME_LENGTH = 32;
    private static final int INTERNET_MAX_PATH_LENGTH = 2048;
    private static final int INTERNET_MAX_URL_LENGTH = 32 + "://\u0000".length() + 2048;
    private UInt32 dwSize = new UInt32();
    private UInt32 dwID = new UInt32();
    private Int iComponentType = new Int();
    private IntBool fChecked = new IntBool();
    private IntBool fDirty = new IntBool();
    private IntBool fNoScroll = new IntBool();
    private ComponentLocation cpPos = new ComponentLocation();
    private WideString wszFriendlyName = new WideString(260);
    private WideString wszSource = new WideString(INTERNET_MAX_URL_LENGTH);
    private WideString wszSubscribedURL = new WideString(INTERNET_MAX_URL_LENGTH);

    public ActiveDesktopItem() {
        this.init(new Parameter[]{this.dwSize, this.dwID, this.iComponentType, this.fChecked, this.fDirty, this.fNoScroll, this.cpPos, this.wszFriendlyName, this.wszSource, this.wszSubscribedURL});
        this.dwSize.setValue((long)this.getLength());
        this.dwID.setValue(0L);
    }

    public ActiveDesktopItem(ActiveDesktopItem that) {
        this();
        this.initFrom(that);
    }

    public ComponentType getComponentType() {
        return (ComponentType)Enums.getItem((Class)ComponentType.class, (int)((int)this.iComponentType.getValue()));
    }

    public void setComponentType(ComponentType value) {
        this.iComponentType.setValue((long)value.getValue());
    }

    public boolean getChecked() {
        return this.fChecked.getBooleanValue();
    }

    public void setChecked(boolean checked) {
        this.fChecked.setBooleanValue(checked);
    }

    public boolean getDirty() {
        return this.fDirty.getBooleanValue();
    }

    public void setDirty(boolean dirty) {
        this.fDirty.setBooleanValue(dirty);
    }

    public boolean getScroll() {
        return this.fNoScroll.getBooleanValue();
    }

    public void setScroll(boolean scroll) {
        this.fNoScroll.setBooleanValue(scroll);
    }

    public ComponentLocation getLocation() {
        return this.cpPos;
    }

    public void setLocation(ComponentLocation location) {
        this.cpPos.copyFrom(location);
    }

    public String getFriendlyName() {
        return this.wszFriendlyName.getValue();
    }

    public void setFriendlyName(String friendlyName) {
        this.wszFriendlyName.setValue(friendlyName);
    }

    public URL getSource() throws MalformedURLException {
        return new URL(this.wszSource.getValue());
    }

    public void setSource(URL source) {
        this.wszSource.setValue(source.toString());
    }

    public URL getSubscribedURL() throws MalformedURLException {
        return new URL(this.wszSubscribedURL.getValue());
    }

    public void setSubscribedURL(URL subscribedURL) {
        this.wszSubscribedURL.setValue(subscribedURL.toString());
    }

    public Object clone() {
        return new ActiveDesktopItem(this);
    }

    public static class ComponentType
    extends EnumItem {
        public static ComponentType HTMLDOC = new ComponentType(0);
        public static ComponentType PICTURE = new ComponentType(1);
        public static ComponentType WEBSITE = new ComponentType(2);
        public static ComponentType CONTROL = new ComponentType(3);
        public static ComponentType CFHTML = new ComponentType(4);

        private ComponentType(int value) {
            super(value);
        }
    }
}

