/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.security;

import com.jniwrapper.AnsiString;
import com.jniwrapper.CharacterEncoding;
import com.jniwrapper.ExternalStringPointer;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int8;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.security.SidIdentifierAuthority;
import com.jniwrapper.win32.system.AdvApi32;
import com.jniwrapper.win32.system.LocalMemoryBlock;

public class Sid
extends Structure {
    private static final String FUNCTION_LOOKUP_ACCOUNT_SID = "LookupAccountSidA";
    private static final String FUNCTION_IS_VALID_SID = "IsValidSid";
    private static final String FUNCTION_GET_LENGTH_SID = "GetLengthSid";
    private static final String FUNCTION_EQUAL_SID = "EqualSid";
    private static final String FUNCTION_INITIALIZE_SID = "InitializeSid";
    private static final String FUNCTION_GET_SID_SUB_AUTHORITY_COUNT = "GetSidSubAuthorityCount";
    private static final String FUNCTION_GET_SID_SUB_AUTHORITY = "GetSidSubAuthority";
    private static final String FUNCTION_CONVERT_SID_TO_STRING_SID = "ConvertSidToStringSidW";
    public static final long SECURITY_DIALUP_RID = 1L;
    public static final long SECURITY_NETWORK_RID = 2L;
    public static final long SECURITY_BATCH_RID = 3L;
    public static final long SECURITY_INTERACTIVE_RID = 4L;
    public static final long SECURITY_LOGON_IDS_RID = 5L;
    public static final long SECURITY_SERVICE_RID = 6L;
    public static final long SECURITY_ANONYMOUS_LOGON_RID = 7L;
    public static final long SECURITY_PROXY_RID = 8L;
    public static final long SECURITY_ENTERPRISE_CONTROLLERS_RID = 9L;
    public static final long SECURITY_SERVER_LOGON_RID = 9L;
    public static final long SECURITY_PRINCIPAL_SELF_RID = 10L;
    public static final long SECURITY_AUTHENTICATED_USER_RID = 11L;
    public static final long SECURITY_RESTRICTED_CODE_RID = 12L;
    public static final long SECURITY_TERMINAL_SERVER_RID = 13L;
    public static final long SECURITY_REMOTE_LOGON_RID = 14L;
    public static final long SECURITY_THIS_ORGANIZATION_RID = 15L;
    public static final long SECURITY_IUSER_RID = 17L;
    public static final long SECURITY_LOCAL_SYSTEM_RID = 18L;
    public static final long SECURITY_LOCAL_SERVICE_RID = 19L;
    public static final long SECURITY_NETWORK_SERVICE_RID = 20L;
    public static final long DOMAIN_ALIAS_RID_ADMINS = 544L;
    public static final long DOMAIN_ALIAS_RID_USERS = 545L;
    public static final long DOMAIN_ALIAS_RID_GUESTS = 546L;
    public static final long DOMAIN_ALIAS_RID_POWER_USERS = 547L;
    public static final long DOMAIN_ALIAS_RID_ACCOUNT_OPS = 548L;
    public static final long DOMAIN_ALIAS_RID_SYSTEM_OPS = 549L;
    public static final long DOMAIN_ALIAS_RID_PRINT_OPS = 550L;
    public static final long DOMAIN_ALIAS_RID_BACKUP_OPS = 551L;
    public static final long DOMAIN_ALIAS_RID_REPLICATOR = 552L;
    public static final long DOMAIN_ALIAS_RID_RAS_SERVERS = 553L;
    public static final long DOMAIN_ALIAS_RID_PREW2KCOMPACCESS = 554L;
    public static final long DOMAIN_ALIAS_RID_REMOTE_DESKTOP_USERS = 555L;
    public static final long DOMAIN_ALIAS_RID_NETWORK_CONFIGURATION_OPS = 556L;
    public static final long DOMAIN_ALIAS_RID_INCOMING_FOREST_TRUST_BUILDERS = 557L;
    public static final long DOMAIN_ALIAS_RID_MONITORING_USERS = 558L;
    public static final long DOMAIN_ALIAS_RID_LOGGING_USERS = 559L;
    public static final long DOMAIN_ALIAS_RID_AUTHORIZATIONACCESS = 560L;
    public static final long DOMAIN_ALIAS_RID_TS_LICENSE_SERVERS = 561L;
    public static final long DOMAIN_ALIAS_RID_DCOM_USERS = 562L;
    public static final long DOMAIN_ALIAS_RID_IUSERS = 568L;
    public static final long DOMAIN_ALIAS_RID_CRYPTO_OPERATORS = 569L;
    public static final long DOMAIN_ALIAS_RID_CACHEABLE_PRINCIPALS_GROUP = 571L;
    public static final long DOMAIN_ALIAS_RID_NON_CACHEABLE_PRINCIPALS_GROUP = 572L;
    public static final long DOMAIN_ALIAS_RID_EVENT_LOG_READERS_GROUP = 573L;
    public static final long SECURITY_NULL_RID = 0L;
    public static final long SECURITY_WORLD_RID = 0L;
    public static final long SECURITY_LOCAL_RID = 0L;
    public static final long SECURITY_BUILTIN_DOMAIN_RID = 32L;
    public static final long SECURITY_WRITE_RESTRICTED_CODE_RID = 33L;
    public static final long SECURITY_CREATOR_OWNER_RID = 0L;
    public static final long SECURITY_CREATOR_GROUP_RID = 1L;
    public static final long SECURITY_CREATOR_OWNER_SERVER_RID = 2L;
    public static final long SECURITY_CREATOR_GROUP_SERVER_RID = 3L;
    public static final long SECURITY_CREATOR_OWNER_RIGHTS_RID = 4L;
    private static final int SUB_AUTHORITY_SIZE = 5;
    private Int8 _revision = new Int8();
    private Int8 _subAuthorityCount = new Int8();
    private SidIdentifierAuthority _identifierAuthority = new SidIdentifierAuthority();
    private Pointer.Void _pSubAuthority = new Pointer.Void();
    private PrimitiveArray _subAuthority = new PrimitiveArray(UInt32.class, 5);

    public Sid() {
        this.init(new Parameter[]{this._revision, this._subAuthorityCount, this._identifierAuthority, this._subAuthority}, (short)8);
    }

    public Sid(SidIdentifierAuthority authority, long[] subAuthRids) {
        this();
        Sid.initializeSid(this, authority, subAuthRids);
    }

    public static Sid Null() {
        return new Sid(SidIdentifierAuthority.SECURITY_NULL_SID_AUTHORITY, new long[]{0L});
    }

    public static Sid World() {
        return new Sid(SidIdentifierAuthority.SECURITY_WORLD_SID_AUTHORITY, new long[]{0L});
    }

    public static Sid Local() {
        return new Sid(SidIdentifierAuthority.SECURITY_LOCAL_SID_AUTHORITY, new long[]{0L});
    }

    public static Sid CreatorOwner() {
        return new Sid(SidIdentifierAuthority.SECURITY_CREATOR_SID_AUTHORITY, new long[]{0L});
    }

    public static Sid CreatorGroup() {
        return new Sid(SidIdentifierAuthority.SECURITY_CREATOR_SID_AUTHORITY, new long[]{1L});
    }

    public static Sid CreatorOwnerServer() {
        return new Sid(SidIdentifierAuthority.SECURITY_CREATOR_SID_AUTHORITY, new long[]{2L});
    }

    public static Sid CreatorGroupServer() {
        return new Sid(SidIdentifierAuthority.SECURITY_CREATOR_SID_AUTHORITY, new long[]{3L});
    }

    public static Sid Dialup() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{1L});
    }

    public static Sid Network() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{2L});
    }

    public static Sid Batch() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{3L});
    }

    public static Sid Interactive() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{4L});
    }

    public static Sid Service() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{6L});
    }

    public static Sid AnonymousLogon() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{7L});
    }

    public static Sid Proxy() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{8L});
    }

    public static Sid ServerLogon() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{9L});
    }

    public static Sid Self() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{10L});
    }

    public static Sid AuthenticatedUser() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{11L});
    }

    public static Sid RestrictedCode() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{12L});
    }

    public static Sid TerminalServer() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{13L});
    }

    public static Sid System() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{18L});
    }

    public static Sid NetworkService() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{20L});
    }

    public static Sid Admins() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{32L, 544L});
    }

    public static Sid Users() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{32L, 545L});
    }

    public static Sid Guests() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{32L, 546L});
    }

    public static Sid PowerUsers() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{32L, 547L});
    }

    public static Sid AccountOps() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{32L, 548L});
    }

    public static Sid SystemOps() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{32L, 549L});
    }

    public static Sid PrintOps() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{32L, 550L});
    }

    public static Sid BackupOps() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{32L, 551L});
    }

    public static Sid Replicator() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{32L, 552L});
    }

    public static Sid RasServers() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{32L, 553L});
    }

    public static Sid PreW2KAccess() {
        return new Sid(SidIdentifierAuthority.SECURITY_NT_AUTHORITY, new long[]{32L, 554L});
    }

    public Int8 getRevision() {
        return this._revision;
    }

    public void setRevision(Int8 revision) {
        this._revision = revision;
    }

    public Int8 getSubAuthorityCount() {
        return this._subAuthorityCount;
    }

    public void setSubAuthorityCount(Int8 subAuthorityCount) {
        this._subAuthorityCount = subAuthorityCount;
    }

    public SidIdentifierAuthority getIdentifierAuthority() {
        return this._identifierAuthority;
    }

    public void setIdentifierAuthority(SidIdentifierAuthority identifierAuthority) {
        this._identifierAuthority = identifierAuthority;
    }

    public PrimitiveArray getSubAuthority() {
        return this._subAuthority;
    }

    public void setSubAuthority(PrimitiveArray subAuthority) {
        this._subAuthority = subAuthority;
    }

    public Pointer.Void getpSubAuthority() {
        return this._pSubAuthority;
    }

    public void setpSubAuthority(Pointer.Void pSubAuthority) {
        this._pSubAuthority = pSubAuthority;
    }

    public boolean lookupAccountSid(AnsiString name, AnsiString domainName) {
        if (!this.isValidSid(this)) {
            return false;
        }
        Function lookupAccountSid = AdvApi32.get(FUNCTION_LOOKUP_ACCOUNT_SID);
        IntBool result = new IntBool();
        Int accountType = new Int();
        UInt32 nameSize = new UInt32(100L);
        UInt32 domainNameSize = new UInt32(100L);
        lookupAccountSid.invoke((Parameter)result, new Parameter[]{new Pointer.Void(), new Pointer((Parameter)this), name, new Pointer((Parameter)nameSize), domainName, new Pointer((Parameter)domainNameSize), new Pointer((Parameter)accountType)});
        return result.getValue() != 0L;
    }

    public boolean isValidSid(Sid sid) {
        Function isValidSid = AdvApi32.get(FUNCTION_IS_VALID_SID);
        IntBool result = new IntBool();
        isValidSid.invoke((Parameter)result, (Parameter)new Pointer((Parameter)sid));
        return result.getValue() != 0L;
    }

    private long getLengthSid(Sid sid) {
        Function isValidSid = AdvApi32.get(FUNCTION_GET_LENGTH_SID);
        IntBool result = new IntBool();
        isValidSid.invoke((Parameter)result, (Parameter)new Pointer((Parameter)sid));
        return result.getValue();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Sid)) {
            return false;
        }
        return Sid.compareSIDs(this, obj);
    }

    public static boolean compareSIDs(Sid sid1, Object sid2) {
        Sid src = (Sid)((Object)sid2);
        if (!sid1.isValidSid(sid1) || !sid1.isValidSid(src)) {
            throw new RuntimeException("Attempt to compare invalid sid");
        }
        Function equalSid = AdvApi32.get(FUNCTION_EQUAL_SID);
        IntBool res = new IntBool();
        equalSid.invoke((Parameter)res, (Parameter)new Pointer.Const((Parameter)sid1), (Parameter)new Pointer.Const((Parameter)src));
        return res.getBooleanValue();
    }

    private static void initializeSid(Sid sid, SidIdentifierAuthority authority, long[] subAuthRids) {
        Function initializeSid = AdvApi32.get(FUNCTION_INITIALIZE_SID);
        IntBool res = new IntBool();
        long lastError = initializeSid.invoke((Parameter)res, (Parameter)new Pointer((Parameter)sid), (Parameter)new Pointer.Const((Parameter)authority), (Parameter)new UInt8((short)subAuthRids.length));
        if (!res.getBooleanValue()) {
            throw new LastErrorException(lastError, "Unable to initialize SID");
        }
        for (int i = 0; i < subAuthRids.length; ++i) {
            UInt32 rid = Sid.getSidSubAuthority(sid, i);
            rid.setValue(subAuthRids[i]);
        }
    }

    private static UInt32 getSidSubAuthority(Sid sid, int index) {
        Function getSidSubAuthority = AdvApi32.get(FUNCTION_GET_SID_SUB_AUTHORITY);
        Pointer ptrRes = new Pointer((Parameter)new UInt32(), true);
        long lastError = getSidSubAuthority.invoke((Parameter)ptrRes, (Parameter)new Pointer.Const((Parameter)sid), (Parameter)new UInt32((long)index));
        if (ptrRes.isNull()) {
            throw new LastErrorException(lastError);
        }
        return (UInt32)ptrRes.getReferencedObject();
    }

    private static UInt8 getSidSubAuthorityCount(Sid sid) {
        Function getSidSubAuthority = AdvApi32.get(FUNCTION_GET_SID_SUB_AUTHORITY_COUNT);
        Pointer ptrRes = new Pointer(null, true);
        getSidSubAuthority.invoke((Parameter)ptrRes, (Parameter)new Pointer.Const((Parameter)sid));
        return (UInt8)ptrRes.getReferencedObject();
    }

    public String convertSidToStringSid() {
        Function convertSidToStringSid = AdvApi32.get(FUNCTION_CONVERT_SID_TO_STRING_SID);
        IntBool res = new IntBool();
        ExternalStringPointer str = new ExternalStringPointer(CharacterEncoding.Unicode);
        long lastError = convertSidToStringSid.invoke((Parameter)res, (Parameter)new Pointer((Parameter)this), (Parameter)new Pointer.OutOnly((Parameter)str));
        if (!res.getBooleanValue()) {
            throw new LastErrorException(lastError);
        }
        String result = str.readString();
        LocalMemoryBlock.localFree((Parameter)str);
        return result;
    }

    public Object clone() {
        Sid sid = new Sid();
        sid.initFrom(this);
        return sid;
    }
}

