/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.io;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;
import com.jniwrapper.WideChar;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.io.FileInfo;
import com.jniwrapper.win32.io.FileSystemEvent;
import com.jniwrapper.win32.io.FileSystemException;
import com.jniwrapper.win32.io.FileSystemWatcher;
import com.jniwrapper.win32.io.WatcherStrategy;
import com.jniwrapper.win32.system.Kernel32;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WinNTWatcherStrategy
extends WatcherStrategy {
    private static final Logger LOG = Logger.getInstance((Class)WinNTWatcherStrategy.class);
    static final FunctionName FUNCTION_CREATE_FILE = new FunctionName("CreateFile");
    static final String FUNCTION_READ_DIRECTORY_CHANGES = "ReadDirectoryChangesW";
    static final int FILE_LIST_DIRECTORY = 1;
    static final int FILE_DELETE_CHILD = 64;
    static final int FILE_ACCESS_MODE = 1;
    static final int FILE_SHARE_READ = 1;
    static final int FILE_SHARE_WRITE = 2;
    static final int FILE_SHARE_DELETE = 4;
    static final int OPEN_EXISTING = 3;
    static final int FILE_FLAG_BACKUP_SEMANTICS = 0x2000000;
    int _bufferSize = 65536;
    private Handle _directory = new Handle();
    private Thread _watcherThread;

    public WinNTWatcherStrategy(FileSystemWatcher fileSystemWatcher) {
        super(fileSystemWatcher);
    }

    public void start() throws FileSystemException {
        FileSystemWatcher watcher = this.getFileSystemWatcher();
        File folder = new File(watcher.getPath());
        if (!folder.exists()) {
            throw new FileSystemException("Folder \"" + folder + "\" does not exist.");
        }
        final Kernel32 kernel32 = Kernel32.getInstance();
        String path = watcher.getPath();
        Function functionCreateFile = kernel32.getFunction(FUNCTION_CREATE_FILE.toString());
        functionCreateFile.invoke((Parameter)this._directory, new Parameter[]{new Str(path), new UInt32(1L), new UInt32(7L), new Pointer(null, true), new UInt32(3L), new UInt32(0x2000000L), new Pointer(null, true)});
        long handleValue = this._directory.getValue();
        if (this._directory.isNull() || handleValue == -1L) {
            throw new FileSystemException("Could not open folder " + folder);
        }
        final long bufferSize = this.getBufferSize();
        final PrimitiveArray buffer = new PrimitiveArray(UInt8.class, this._bufferSize);
        final boolean watchSubtree = watcher.isWatchSubree();
        final int notifyFilter = (int)watcher.getOptions().getFlags();
        final UInt32 bytesReturned = new UInt32();
        this._watcherThread = new Thread(new Runnable(){

            public void run() {
                WinNTWatcherStrategy.this.setWatching(true);
                while (WinNTWatcherStrategy.this.isWatching()) {
                    Function functionReadDirectoryChanges = kernel32.getFunction(WinNTWatcherStrategy.FUNCTION_READ_DIRECTORY_CHANGES);
                    Int returnValue = new Int();
                    functionReadDirectoryChanges.invoke((Parameter)returnValue, new Parameter[]{WinNTWatcherStrategy.this._directory, new Pointer((Parameter)buffer), new UInt32(bufferSize), new Bool(watchSubtree), new UInt32((long)notifyFilter), new Pointer((Parameter)bytesReturned), new Pointer(null, true), new Pointer(null, true)});
                    long value = returnValue.getValue();
                    if (value != 0L && WinNTWatcherStrategy.this.isWatching()) {
                        WinNTWatcherStrategy.this.fireEvents(WinNTWatcherStrategy.this.retrieveEvents(buffer.getBytes()));
                        continue;
                    }
                    WinNTWatcherStrategy.this.notifyIfWatchedFolderRemoved();
                    WinNTWatcherStrategy.this.unlockWatchedFolder();
                    break;
                }
            }
        });
        this._watcherThread.start();
    }

    public void setBufferSize(int value) {
        this._bufferSize = value;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    private List retrieveEvents(byte[] buffer) {
        FileSystemWatcher watcher = this.getFileSystemWatcher();
        int index = 0;
        int nextEntryIndex = 0;
        boolean lastEvent = false;
        ArrayList<FileActionInfo> actionInfos = new ArrayList<FileActionInfo>();
        while (index < this._bufferSize && !lastEvent) {
            int nextEntryOffset = this.readDWORD(buffer, index);
            nextEntryIndex += nextEntryOffset;
            lastEvent = nextEntryOffset == 0;
            int action = this.readDWORD(buffer, index += 4);
            int fileNameLength = this.readDWORD(buffer, index += 4);
            index += 4;
            StringBuffer fileName = new StringBuffer(watcher.getPath());
            fileName.append(File.separatorChar);
            for (int i = 0; i < fileNameLength >> 1; ++i) {
                char c = this.readWCHAR(buffer, index);
                index += 2;
                fileName.append(c);
            }
            actionInfos.add(new FileActionInfo(new FileInfo(fileName.toString(), 0L, 0L, 0L), action));
            index = nextEntryIndex;
        }
        int actionInfoCount = actionInfos.size();
        ArrayList<FileSystemEvent> events = new ArrayList<FileSystemEvent>(actionInfoCount);
        for (int i = 0; i < actionInfoCount; ++i) {
            FileSystemEvent event = null;
            FileActionInfo actionInfo = (FileActionInfo)actionInfos.get(i);
            if (actionInfo.getAction() == 4) {
                if (i + 1 < actionInfoCount) {
                    FileActionInfo newActionInfo = (FileActionInfo)actionInfos.get(++i);
                    event = new FileSystemEvent(watcher, actionInfo.getAction(), actionInfo.getFileInfo(), newActionInfo.getFileInfo());
                }
            } else {
                event = new FileSystemEvent(watcher, actionInfo.getAction(), actionInfo.getFileInfo());
            }
            events.add(event);
        }
        return events;
    }

    private void fireEvents(List events) {
        FileSystemWatcher watcher = this.getFileSystemWatcher();
        FileFilter fileFilter = watcher.getFileFilter();
        Iterator i = events.iterator();
        while (i.hasNext()) {
            FileSystemEvent event = (FileSystemEvent)i.next();
            if (fileFilter != null) {
                File file1 = new File(event.getFileInfo().getFileName());
                File file2 = null;
                if (event.getOldFileInfo() != null) {
                    file2 = new File(event.getOldFileInfo().getFileName());
                }
                if (!fileFilter.accept(file1) && (file2 == null || !fileFilter.accept(file2))) continue;
                watcher.fireFileSystemEvent(event);
                continue;
            }
            watcher.fireFileSystemEvent(event);
        }
    }

    private int readDWORD(byte[] buffer, int offset) {
        UInt32 result = new UInt32();
        result.read(buffer, offset);
        return (int)result.getValue();
    }

    private char readWCHAR(byte[] buffer, int offset) {
        WideChar result = new WideChar();
        result.read(buffer, offset);
        return result.getValue();
    }

    public void stop() throws FileSystemException {
        this.setWatching(false);
        this.awakeWatcher();
        while (this._watcherThread.isAlive()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }
        this.unlockWatchedFolder();
    }

    private void awakeWatcher() {
        try {
            File watchedFolder = new File(this.getFileSystemWatcher().getPath());
            if (watchedFolder.exists()) {
                File dummyFile = new File(watchedFolder, "notify");
                dummyFile.createNewFile();
                dummyFile.delete();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    private void notifyIfWatchedFolderRemoved() {
        File watchedFolder = new File(this.getFileSystemWatcher().getPath());
        if (!watchedFolder.exists()) {
            FileSystemEvent event = new FileSystemEvent(this.getFileSystemWatcher(), 2, new FileInfo(watchedFolder.getAbsolutePath(), 0L, 0L, 0L));
            ArrayList<FileSystemEvent> events = new ArrayList<FileSystemEvent>();
            events.add(event);
            this.fireEvents(events);
        }
    }

    private void unlockWatchedFolder() {
        if (this._directory.getValue() != -1L && !this._directory.isNull()) {
            Handle.closeHandle(this._directory);
            this._directory.setValue(0L);
        }
    }

    class FileActionInfo {
        private FileInfo _fileInfo;
        private int _action;

        public FileActionInfo(FileInfo fileInfo, int action) {
            this._fileInfo = fileInfo;
            this._action = action;
        }

        public FileInfo getFileInfo() {
            return this._fileInfo;
        }

        public int getAction() {
            return this._action;
        }
    }
}

