/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.hook;

import com.jniwrapper.win32.hook.CBTEvent;
import com.jniwrapper.win32.hook.CBTHookListener;
import com.jniwrapper.win32.hook.Hook;
import com.jniwrapper.win32.hook.HookEventListener;
import com.jniwrapper.win32.hook.HookEventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class CBTHook
extends Hook {
    private final List listeners = new LinkedList();

    CBTHook() {
        super(Hook.Descriptor.CBT);
        this.setSynchronous(true);
        this.addListener(new HookEventListener(){

            public void onHookEvent(HookEventObject event) {
                CBTEvent cbtEvent = (CBTEvent)event;
                try {
                    CBTHook.this.notifyListeners(cbtEvent);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void notifyListeners(CBTEvent cbtEvent) {
        LinkedList listenersCopy = new LinkedList(this.listeners);
        Iterator i = listenersCopy.iterator();
        while (i.hasNext()) {
            CBTHookListener listener = (CBTHookListener)i.next();
            cbtEvent.dispatch(listener);
        }
    }

    public void addListener(CBTHookListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CBTHookListener listener) {
        this.listeners.remove(listener);
    }

    public void setSynchronous(boolean synchronous) {
        if (!synchronous) {
            throw new IllegalArgumentException(this.getDescriptor().getName() + " is not designed to work in asynchronous mode");
        }
        super.setSynchronous(synchronous);
    }
}

