/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.DataBufferFactory;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.MemoryBuffer;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;
import com.jniwrapper.util.ImageUtils;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.gdi.Bitmap;
import com.jniwrapper.win32.gdi.BitmapInfo;
import com.jniwrapper.win32.gdi.BitmapInfoHeader;
import com.jniwrapper.win32.gdi.BitmapStructure;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.DDBitmap;
import com.jniwrapper.win32.gdi.DibSection;
import com.jniwrapper.win32.gdi.Gdi32;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.RGBQuad;
import com.jniwrapper.win32.gdi.WindowDC;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilder;
import com.jniwrapper.win32.ui.User32;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class DIBitmap
extends Bitmap {
    private static String FUNCTION_GETDIBCOLORTABLE = "GetDIBColorTable";

    public DIBitmap() {
        this.setSize(0, 0);
    }

    public DIBitmap(long value) {
        super(value);
        this.setSize(0, 0);
    }

    public DIBitmap(int width, int height) {
        this(new DDBitmap(width, height));
    }

    public DIBitmap(DDBitmap ddBitmap) {
        BitmapInfoHeader bitmapInfo = ddBitmap.getBitmapInfoHeader();
        int height = (int)bitmapInfo.getHeight();
        int width = (int)bitmapInfo.getWidth();
        int bitscount = (int)bitmapInfo.getSizeImage();
        PrimitiveArray bits = new PrimitiveArray(UInt8.class, bitscount);
        Pointer pbits = new Pointer((Parameter)bits);
        this.createDIBSection(this, new WindowDC(null), ddBitmap.getBitmapInfo(), 0, new Pointer((Parameter)pbits), new Handle(), 0);
        ddBitmap.getDIBits((DC)new WindowDC(null), 0, height, pbits, ddBitmap.getBitmapInfo(), 0);
        this.setSize(width, height);
    }

    public DIBitmap(BitmapInfo bitmapInfo) {
        int height = (int)bitmapInfo.getBitmapInfoHeader().getHeight();
        int width = (int)bitmapInfo.getBitmapInfoHeader().getWidth();
        PrimitiveArray bits = new PrimitiveArray((Parameter)new UInt8(0), (int)bitmapInfo.getBitmapInfoHeader().getSizeImage());
        Pointer pbits = new Pointer((Parameter)bits);
        this.createDIBSection(this, new WindowDC(null), bitmapInfo, 0, new Pointer((Parameter)pbits), new Handle(), 0);
        this.setSize(width, height);
    }

    public DIBitmap(String fileName) {
        this.loadFromFile(fileName);
    }

    public DIBitmap(Image image) {
        BufferedImage bufferedImage = ImageUtils.createBufferedImage((Image)image);
        this.setBitsForBitmap(bufferedImage);
        this.setSize((int)this.getBitmapInfoHeader().getWidth(), (int)this.getBitmapInfoHeader().getHeight());
    }

    public void loadFromFile(String fileName) {
        Function function = User32.getInstance().getFunction(User32.FUNCTION_LOAD_IMAGE.toString());
        Handle result = new Handle();
        long errorCode = function.invoke((Parameter)result, new Parameter[]{new Pointer(null, true), new Str(fileName), new UInt((long)GdiObject.ImageType.BITMAP.getValue()), new Int(0L), new Int(0L), new UInt(41040L)});
        if (result.isNull()) {
            throw new LastErrorException(errorCode, "Failed to load resource.", true);
        }
        this.setValue(result.getValue());
        BitmapInfoHeader bitmapInfo = this.getBitmapInfoHeader();
        this.setSize((int)bitmapInfo.getWidth(), (int)bitmapInfo.getHeight());
    }

    private void setBitsForBitmap(BufferedImage bufferedImage) {
        BitmapBuilder builder = _builderFactory.createBuilder(bufferedImage);
        BitmapInfo bitmapInfo = builder.getBitmapInfo();
        this.createDIBSection(this, new Pointer((Parameter)new Pointer((Parameter)builder.getBitmapData())), bitmapInfo);
        builder.setBitmapColors();
        Image transparentMaskImage = builder.getTransparentMask();
        if (transparentMaskImage != null) {
            this.setTransparentMask(transparentMaskImage);
        }
    }

    public BitmapInfoHeader getBitmapInfoHeader() {
        DibSection dibSection = new DibSection();
        this.getObject(this, (Parameter)dibSection);
        return dibSection.getBitmapInfoHeader();
    }

    public BitmapStructure getBitmapStructure() {
        DibSection dibSection = new DibSection();
        this.getObject(this, (Parameter)dibSection);
        return dibSection.getBitmap();
    }

    public BitmapInfo getBitmapInfo() {
        BitmapInfo bitmapInfo = new BitmapInfo();
        bitmapInfo.setBitmapInfoHeader(this.getBitmapInfoHeader());
        int bitcount = (int)this.getBitmapInfoHeader().getBitCount();
        if (bitcount <= 8) {
            Function function = Gdi32.getInstance().getFunction(FUNCTION_GETDIBCOLORTABLE);
            DC dc = DC.createCompatibleDC(new WindowDC(null));
            dc.selectObject(this);
            UInt res = new UInt();
            PrimitiveArray rgbQuad = new PrimitiveArray(RGBQuad.class, (int)Math.pow(2.0, bitcount));
            function.invoke((Parameter)res, new Parameter[]{dc, new UInt(0L), new UInt((long)((int)Math.pow(2.0, bitcount))), new Pointer((Parameter)rgbQuad)});
            dc.release();
            bitmapInfo.setColors(rgbQuad);
        }
        return bitmapInfo;
    }

    public DibSection getDIBSection() {
        DibSection dibSection = new DibSection();
        this.getObject(this, (Parameter)dibSection);
        return dibSection;
    }

    public DDBitmap toDDBitmap(DC dc) {
        DDBitmap result = new DDBitmap(dc, this.getWidth(), this.getHeight());
        PrimitiveArray bits = this.getDIBytes();
        Function function = Gdi32.getInstance().getFunction("CreateDIBitmap");
        function.invoke((Parameter)result, new Parameter[]{dc, new Pointer((Parameter)this.getDIBSection().getBitmapInfoHeader()), new UInt32(4L), new Pointer((Parameter)bits), new Pointer((Parameter)this.getBitmapInfo()), new UInt(0L)});
        return result;
    }

    public PrimitiveArray getDIBytes() {
        BitmapStructure bitmap = this.getBitmapStructure();
        PrimitiveArray bits = new PrimitiveArray(UInt8.class, (int)this.getBitmapInfoHeader().getSizeImage());
        bitmap.getBits().castTo(new Pointer((Parameter)bits));
        return bits;
    }

    public byte[] getBytes() {
        BitmapStructure bitmap = this.getBitmapStructure();
        int height = this.getHeight();
        int width = this.getWidth();
        int bitPerPixel = this.getBitCount();
        int bytesCount = DIBitmap.getBytesCount(height, width, bitPerPixel);
        MemoryBuffer bitsBuffer = DataBufferFactory.getInstance().createExternMemoryBuffer(bitmap.getBits().getValue(), bytesCount);
        return bitsBuffer.readByteArray(0, bytesCount);
    }

    public void setDIBytes(PrimitiveArray bytes) {
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        PrimitiveArray bits = bytes;
        this.setDIBits(new WindowDC(null), 0, this.getHeight(), new Pointer((Parameter)bits), bitmapInfo, 0);
    }
}

