/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.dde;

import com.jniwrapper.Bool;
import com.jniwrapper.Callback;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.UInt8;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.dde.DdeException;
import com.jniwrapper.win32.ui.User32;

class DdeFunctions {
    private static final FunctionName FUNCTION_INITIALIZE = new FunctionName("DdeInitialize");
    private static final String FUNCTION_GETLASTERROR = "DdeGetLastError";
    private static final String FUNCTION_UNINITIALIZE = "DdeUninitialize";
    private static final String FUNCTION_CREATEDATAHANDLE = "DdeCreateDataHandle";
    private static final String FUNCTION_GETDATA = "DdeGetData";
    private static final String FUNCTION_FREESTRINGHANDLE = "DdeFreeStringHandle";
    private static final String FUNCTION_FREEDATAHANDLE = "DdeFreeDataHandle";
    private static final FunctionName FUNCTION_CREATESTRINGHANDLE = new FunctionName("DdeCreateStringHandle");
    private static final long APPCLASS_STANDARD = 0L;
    private static final long CP_WINUNICODE = 1200L;
    private static final long CP_WINANSI = 1004L;
    private static final long HDATA_APPOWNED = 1L;

    DdeFunctions() {
    }

    public static long getCodePage() {
        if (PlatformContext.isUnicode()) {
            return 1200L;
        }
        return 1004L;
    }

    public static long ddeInitialize(Callback callback) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_INITIALIZE.toString());
        UInt result = new UInt();
        UInt32 idInst = new UInt32(0L);
        function.invoke((Parameter)result, (Parameter)new Pointer((Parameter)idInst), (Parameter)callback, (Parameter)new UInt32(0L), (Parameter)new UInt32(0L));
        if (result.getValue() != 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst.getValue()));
        }
        return idInst.getValue();
    }

    public static void ddeUninitialize(long idInst) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_UNINITIALIZE);
        IntBool result = new IntBool();
        function.invoke((Parameter)result, (Parameter)new UInt32(idInst));
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
    }

    public static int getLastError(long idInst) {
        Function function = User32.getInstance().getFunction(FUNCTION_GETLASTERROR);
        UInt result = new UInt();
        function.invoke((Parameter)result, (Parameter)new UInt32(idInst));
        return (int)result.getValue();
    }

    public static Handle createStringHandle(long idInst, String string) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_CREATESTRINGHANDLE.toString());
        Handle result = new Handle();
        function.invoke((Parameter)result, (Parameter)new UInt32(idInst), (Parameter)new Str(string), (Parameter)new Int(DdeFunctions.getCodePage()));
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
        return result;
    }

    public static Handle createDataHandle(long idInst, byte[] data, int offset, long format, Handle item) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_CREATEDATAHANDLE);
        PrimitiveArray paData = new PrimitiveArray(data);
        Handle retVal = new Handle();
        function.invoke((Parameter)retVal, new Parameter[]{new UInt32(idInst), new Pointer((Parameter)paData), new UInt32((long)paData.getElementCount()), new UInt32((long)offset), item == null ? new Handle() : item, new UInt(format), new UInt(1L)});
        if (retVal.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
        return retVal;
    }

    public static byte[] getData(Handle data) {
        Function function = User32.getInstance().getFunction(FUNCTION_GETDATA);
        UInt32 count = new UInt32();
        function.invoke((Parameter)count, (Parameter)data, (Parameter)new Pointer(null, true), (Parameter)new UInt32(0L), (Parameter)new UInt32(0L));
        PrimitiveArray retVal = new PrimitiveArray(UInt8.class, (int)count.getValue());
        function.invoke((Parameter)count, (Parameter)data, (Parameter)new Pointer((Parameter)retVal), (Parameter)new UInt32(count.getValue()), (Parameter)new UInt32(0L));
        return retVal.getBytes();
    }

    public static void freeStringHandle(long idInst, Handle handle) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_FREESTRINGHANDLE);
        IntBool result = new IntBool();
        function.invoke((Parameter)result, (Parameter)new UInt32(idInst), (Parameter)handle);
        if (result.getValue() == 0L) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
    }

    public static void freeDataHandle(long idInst, Handle handle) throws DdeException {
        Function function = User32.getInstance().getFunction(FUNCTION_FREEDATAHANDLE);
        Bool result = new Bool();
        function.invoke((Parameter)result, (Parameter)handle);
        if (!result.getValue()) {
            throw new DdeException(DdeFunctions.getLastError(idInst));
        }
    }
}

