/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.dde;

import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.MessageLoopThread;
import com.jniwrapper.win32.dde.DdeClientEventHandler;
import com.jniwrapper.win32.dde.DdeClientHelper;
import com.jniwrapper.win32.dde.DdeException;
import com.jniwrapper.win32.dde.DdeItem;
import java.lang.reflect.InvocationTargetException;

public class DdeClient {
    private static final Logger _log = Logger.getInstance((Class)DdeClient.class);
    private String _service;
    private String _topic;
    private MessageLoopThread _messageLoop;
    private DdeClientEventHandler _clientEventHandler;
    private DdeClientHelper _ddeClientHelper = new DdeClientHelper();

    public DdeClient(String service, String topic) {
        this._service = service;
        this._topic = topic;
        try {
            this.invokeHelperMethod("createCallback", null);
        }
        catch (DdeException e) {
            _log.error((Object)"", (Throwable)e);
        }
    }

    public void connect() throws DdeException {
        this.invokeHelperMethod("connect", new Object[]{this._service, this._topic});
        if (this._clientEventHandler != null) {
            this.setEventHandler(this._clientEventHandler);
        }
    }

    public void disconnect() throws DdeException {
        this.invokeHelperMethod("disconnect", null);
    }

    public long getAsync(DdeItem item) throws DdeException {
        Long result = (Long)this.invokeHelperMethod("getAsync", new Object[]{item});
        return result;
    }

    public byte[] get(DdeItem item, long timeout) throws DdeException {
        Object result = this.invokeHelperMethod("get", new Object[]{item, new Long(timeout)});
        return (byte[])result;
    }

    public long sendAsync(DdeItem item, byte[] data) throws DdeException {
        Long result = (Long)this.invokeHelperMethod("sendAsync", new Object[]{item, data});
        return result;
    }

    public void send(DdeItem item, byte[] data, long timeout) throws DdeException {
        this.invokeHelperMethod("send", new Object[]{item, data, new Long(timeout)});
    }

    public long executeAsync(String command) throws DdeException {
        Long result = (Long)this.invokeHelperMethod("executeAsync", new Object[]{command});
        return result;
    }

    public void execute(String command, long timeout) throws DdeException {
        this.invokeHelperMethod("execute", new Object[]{command, new Long(timeout)});
    }

    public long startAdviseLoopAsync(DdeItem item, boolean sendData, boolean sync) throws DdeException {
        Long result = (Long)this.invokeHelperMethod("startAdviseLoopAsync", new Object[]{item, new Boolean(sendData), new Boolean(sync)});
        return result;
    }

    public void startAdviseLoop(DdeItem item, boolean sendData, boolean sync, long timeout) throws DdeException {
        this.invokeHelperMethod("startAdviseLoop", new Object[]{item, new Boolean(sendData), new Boolean(sync), new Long(timeout)});
    }

    public long stopAdviseLoopAsync(DdeItem item) throws DdeException {
        Long result = (Long)this.invokeHelperMethod("stopAdviseLoopAsync", new Object[]{item});
        return result;
    }

    public void stopAdviseLoop(DdeItem item, long timeout) throws DdeException {
        this.invokeHelperMethod("stopAdviseLoop", new Object[]{item, new Long(timeout)});
    }

    public void abandonTransaction(long transactionID) throws DdeException {
        this.invokeHelperMethod("abandonTransaction", new Object[]{new Long(transactionID)});
    }

    public String getServiceName() {
        return this._service;
    }

    public String getTopicName() {
        return this._topic;
    }

    public void setEventHandler(DdeClientEventHandler eventHandler) {
        if (!this._ddeClientHelper.isConnected()) {
            this._clientEventHandler = eventHandler;
        } else {
            this._ddeClientHelper.setEventHandler(eventHandler);
        }
    }

    public void removeEventHandler() {
        this._ddeClientHelper.removeEventHandler();
    }

    private MessageLoopThread getMessageLoop() {
        if (this._messageLoop == null) {
            this._messageLoop = new MessageLoopThread();
            this._messageLoop.doStart();
        }
        return this._messageLoop;
    }

    private Object invokeHelperMethod(String methodName, Object[] params) throws DdeException {
        Object result = null;
        try {
            result = this.getMessageLoop().doInvokeMethod(this._ddeClientHelper, methodName, params);
        }
        catch (InterruptedException e) {
            _log.error((Object)"", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DdeException) {
                throw (DdeException)cause;
            }
            _log.error((Object)"", (Throwable)e);
        }
        return result;
    }
}

