/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LazyPanel;
import com.jniwrapper.win32.system.VersionInfo;
import com.jniwrapper.win32.ui.FlashInfo;
import com.jniwrapper.win32.ui.Wnd;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WindowDecorationsSample
extends LazyPanel {
    private JLabel lblAdvisoryText;
    private JCheckBox chkTransparent;
    private JCheckBox chkTopmost;
    private JCheckBox chkPalette;
    private JCheckBox chkCaption;
    private JButton btnFlashWindow;
    private JSlider _slider;
    private Wnd _decorator;
    private boolean _flashing = false;
    private JLabel lblNotSupported;

    public WindowDecorationsSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        VersionInfo versionInfo = new VersionInfo();
        boolean isWin98 = false;
        boolean isWin2k = false;
        if (versionInfo.getMajor() > 5L) {
            isWin98 = true;
            isWin2k = true;
        } else if (versionInfo.getMajor() > 4L || versionInfo.getMajor() == 4L && versionInfo.getMinor() >= 10L) {
            isWin98 = true;
        }
        final Window parent = this.getParentWindow();
        this._decorator = new Wnd((Component)parent);
        this.lblAdvisoryText = new HTMLText("This page demonstrates various window decorations using the Wnd class.<br><b>NOTE:</b> The sun.java2d.noddraw=True option is required for transparency feature.");
        this.chkTransparent = new JCheckBox("Transparent", false);
        if (!isWin2k) {
            this.chkTransparent.setEnabled(false);
        }
        this.chkTransparent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    public void run() {
                        boolean transparent = WindowDecorationsSample.this.chkTransparent.isSelected();
                        byte transparency = (byte)WindowDecorationsSample.this._slider.getValue();
                        if (transparent) {
                            WindowDecorationsSample.this._decorator.setTransparent(transparency);
                        } else {
                            WindowDecorationsSample.this._decorator.setTransparent((byte)0);
                        }
                        parent.update(parent.getGraphics());
                    }
                }).start();
            }
        });
        this._slider = new JSlider(0);
        this._slider.setMinimum(100);
        this._slider.setMaximum(255);
        this._slider.setValue(200);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("Transparent"));
        labelTable.put(new Integer(255), new JLabel("Opaque"));
        this._slider.setLabelTable(labelTable);
        this._slider.setMajorTickSpacing(10);
        this._slider.setPaintTicks(true);
        this._slider.setPaintLabels(true);
        if (!isWin2k) {
            this._slider.setEnabled(false);
        }
        this._slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (WindowDecorationsSample.this._decorator.isTransparent() & !source.getValueIsAdjusting()) {
                    byte transparency = (byte)source.getValue();
                    WindowDecorationsSample.this._decorator.setTransparency(transparency);
                }
            }
        });
        this.chkTopmost = new JCheckBox("Always-on-top", false);
        this.chkTopmost.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowDecorationsSample.this._decorator.setTopmost(WindowDecorationsSample.this.chkTopmost.isSelected());
            }
        });
        this.chkPalette = new JCheckBox("Palette style", false);
        this.chkPalette.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowDecorationsSample.this._decorator.setPalleteWindow(WindowDecorationsSample.this.chkPalette.isSelected());
                parent.validate();
            }
        });
        this.chkCaption = new JCheckBox("Show caption", true);
        this.chkCaption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowDecorationsSample.this._decorator.setCaptionVisible(WindowDecorationsSample.this.chkCaption.isSelected());
                parent.validate();
            }
        });
        this.btnFlashWindow = new JButton("Start Window Flashing");
        if (!isWin98) {
            this.btnFlashWindow.setEnabled(false);
        }
        this.btnFlashWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowDecorationsSample.this._flashing = !WindowDecorationsSample.this._flashing;
                if (WindowDecorationsSample.this._flashing) {
                    WindowDecorationsSample.this.btnFlashWindow.setText("Stop Window Flashing");
                } else {
                    WindowDecorationsSample.this.btnFlashWindow.setText("Start Window Flashing");
                }
                FlashInfo.FlashOptions flashOptions = new FlashInfo.FlashOptions();
                flashOptions.setFlashAll(WindowDecorationsSample.this._flashing);
                if (WindowDecorationsSample.this._flashing) {
                    flashOptions.setFlashContinuously(true);
                }
                Wnd windowHandle = WindowDecorationsSample.this._decorator;
                FlashInfo flashInfo = new FlashInfo(windowHandle, flashOptions, 0L, 0L);
                windowHandle.flashWindow(flashInfo);
            }
        });
        this.lblNotSupported = !isWin98 ? new HTMLText("<b><FONT color = red>NOTE:</FONT> Window transparency and window flashing features are not supported by current version of operation system.</b>") : (!isWin2k ? new HTMLText("<b><FONT color = red>NOTE:</FONT> Window transparency feature is not supported by current version of operation system.</b>") : new JLabel());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.chkTransparent, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._slider, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 10), 0, 0));
        this.add((Component)this.chkTopmost, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.chkPalette, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.chkCaption, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.btnFlashWindow, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.lblNotSupported, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 2, new Insets(15, 10, 0, 0), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.btnFlashWindow.setPreferredSize(new Dimension(145, 25));
        super.initialize();
    }
}

