/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.BasicDemoShell;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.gdi.SystemColor;
import com.jniwrapper.win32.samples.demo.SourcePanel;
import com.jniwrapper.win32.ui.Wnd;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class WinPackDemo
extends BasicDemoShell {
    private static final Logger LOG = Logger.getInstance((Class)WinPackDemo.class);
    private static final String xmlFile = "WinPackDemo.xml";
    private static WinPackDemo _instance;

    private WinPackDemo() throws IOException {
        super(WinPackDemo.class.getResource(xmlFile).openStream(), SourcePanel.class);
    }

    private static WinPackDemo getInstance() {
        if (_instance == null) {
            try {
                _instance = new WinPackDemo();
            }
            catch (IOException e) {
                LOG.error((Object)"", (Throwable)e);
                System.exit(1);
            }
        }
        return _instance;
    }

    private static void setupLF() {
        UIDefaults defaults = UIManager.getDefaults();
        Font tahoma = new Font("Tahoma", 0, 11);
        Color btnFaceFolor = SystemColor.BTNFACE.getColor();
        Color highlight = SystemColor.HIGHLIGHT.getColor();
        Color highlightText = SystemColor.HIGHLIGHTTEXT.getColor();
        Color scrollBar = SystemColor.SCROLLBAR.getColor();
        defaults.put("Button.font", tahoma);
        defaults.put("Button.background", btnFaceFolor);
        defaults.put("ToggleButton.font", tahoma);
        defaults.put("ToggleButton.background", btnFaceFolor);
        defaults.put("RadioButton.font", tahoma);
        defaults.put("CheckBox.font", tahoma);
        defaults.put("CheckBox.background", btnFaceFolor);
        defaults.put("Slider.font", tahoma);
        defaults.put("Slider.background", btnFaceFolor);
        defaults.put("Slider.foreground", scrollBar);
        defaults.put("ComboBox.font", tahoma);
        defaults.put("ComboBox.background", btnFaceFolor);
        defaults.put("ComboBox.buttonHighlight", highlight);
        defaults.put("ComboBox.selectionBackground", highlight);
        defaults.put("ComboBox.selectionForeground", highlightText);
        defaults.put("Label.font", tahoma);
        defaults.put("Label.foreground", Color.black);
        defaults.put("List.font", tahoma);
        defaults.put("List.selectionBackground", highlight);
        defaults.put("List.selectionForeground", highlightText);
        defaults.put("Panel.font", tahoma);
        defaults.put("Panel.background", btnFaceFolor);
        defaults.put("ScrollPane.font", tahoma);
        defaults.put("ScrollBar.background", scrollBar);
        defaults.put("ScrollBar.foreground", btnFaceFolor);
        defaults.put("ScrollBar.thumb", btnFaceFolor);
        defaults.put("ScrollBar.thumbHighlight", btnFaceFolor);
        defaults.put("Viewport.font", tahoma);
        defaults.put("Viewport.background", Color.white);
        defaults.put("Table.font", tahoma);
        defaults.put("Table.selectionBackground", highlight);
        defaults.put("Table.selectionForeground", highlightText);
        defaults.put("TableHeader.font", tahoma);
        defaults.put("TableHeader.background", btnFaceFolor);
        defaults.put("TextField.font", tahoma);
        defaults.put("TextField.selectionBackground", highlight);
        defaults.put("TextField.selectionForeground", highlightText);
        defaults.put("TextArea.font", tahoma);
        defaults.put("TextArea.background", Color.white);
        defaults.put("TextArea.foreground", Color.black);
        defaults.put("TextArea.selectionBackground", highlight);
        defaults.put("TextArea.selectionForeground", highlightText);
        defaults.put("Tree.font", tahoma);
        defaults.put("Tree.selectionBackground", highlight);
        defaults.put("Tree.selectionForeground", highlightText);
        defaults.put("Table.focusCellHighlightBorder", new EmptyBorder(1, 1, 1, 1));
        defaults.put("SplitPane.background", btnFaceFolor);
        defaults.put("SplitPane.foreground", btnFaceFolor);
        defaults.put("SplitPane.highlight", btnFaceFolor);
        defaults.put("SplitPane.shadow", btnFaceFolor);
        defaults.put("SplitPane.darkShadow", btnFaceFolor);
        defaults.put("SplitPaneDivider.border", new EmptyBorder(0, 0, 0, 0));
        defaults.put("ToolTip.font", tahoma);
        defaults.put("ToolTip.background", SystemColor.INFOBK.getColor());
        defaults.put("ToolTip.foreground", SystemColor.INFOTEXT.getColor());
        defaults.put("OptionPane.font", tahoma);
        defaults.put("OptionPane.messageFont", tahoma);
        defaults.put("OptionPane.background", btnFaceFolor);
        defaults.put("Desktop.background", btnFaceFolor);
        defaults.put("PopupMenu.background", SystemColor.MENU.getColor());
        defaults.put("MenuItem.background", SystemColor.MENU.getColor());
        defaults.put("MenuItem.font", tahoma);
        defaults.put("MenuItem.selectionBackground", SystemColor.HIGHLIGHT.getColor());
        defaults.put("MenuItem.selectionForeground", SystemColor.HIGHLIGHTTEXT.getColor());
        defaults.put("TabbedPane.font", tahoma);
    }

    private static void createGUI() {
        WinPackDemo window = WinPackDemo.getInstance();
        window.setSize(750, 630);
        Dimension screenSize = window.getToolkit().getScreenSize();
        window.setLocation((screenSize.width - window.getWidth()) / 2, (screenSize.height - window.getHeight()) / 2);
        window.setVisible(true);
        try {
            Wnd decorator = new Wnd((Component)window);
            Icon bigIcon = new Icon(WinPackDemo.class.getResourceAsStream("res/winpack.ico"), Icon.IconType.BIG.getSize());
            Icon smallIcon = new Icon(WinPackDemo.class.getResourceAsStream("res/winpack.ico"), Icon.IconType.SMALL.getSize());
            decorator.setWindowIcon(smallIcon, Icon.IconType.SMALL);
            decorator.setWindowIcon(bigIcon, Icon.IconType.BIG);
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        WinPackDemo.setupLF();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WinPackDemo.createGUI();
            }
        });
    }
}

