/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.NoSuchFunctionException;
import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LazyPanel;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.shell.TrayIcon;
import com.jniwrapper.win32.shell.TrayIconListener;
import com.jniwrapper.win32.shell.TrayMessage;
import com.jniwrapper.win32.system.DllVersionInfo;
import com.jniwrapper.win32.system.VersionInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class TrayIconSample
extends LazyPanel
implements ActionListener {
    private static final Logger LOG = Logger.getInstance((Class)TrayIconSample.class);
    private static final String MENU_ITEM_SHOW_TRAY_ICON = "Show Tray Icon";
    private static final String MENU_ITEM_SHOW_STANDARD_ICON = "Show Standard System Icon";
    private static final String MENU_ITEM_SHOW_CUSTOM_ICON = "Show Custom Icon";
    private static final String MENU_ITEM_SHOW_CALLOUT = "Show Tray Balloon";
    private static final String MENU_HIDE_TRAY_ICON = "Hide Tray Icon";
    private JLabel lblAdvisoryText;
    private JButton btnShowTrayIcon;
    private JButton btnShowStandardSystemIcon;
    private JButton btnShowCustomIcon;
    private JButton btnShowTrayBallon;
    private JButton btnHideTrayIcon;
    private TrayIcon _trayIcon;
    private JPopupMenu _popupMenu;
    private JLabel lblNotSupported;
    private boolean _isVersionOK;

    public TrayIconSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        try {
            DllVersionInfo dllVersionInfo = new DllVersionInfo("Shell32");
            this._isVersionOK = dllVersionInfo.getMajorVersion() >= 5;
        }
        catch (NoSuchFunctionException e) {
            this._isVersionOK = false;
        }
        this.lblAdvisoryText = new HTMLText("This page demonstrates the Tray Icon abilities: misc. icons, menu, balloons. Please right-click on the tray icon to see the pop-up menu.");
        this.btnShowTrayIcon = new JButton(MENU_ITEM_SHOW_TRAY_ICON);
        this.btnShowTrayIcon.setActionCommand(MENU_ITEM_SHOW_TRAY_ICON);
        this.btnShowTrayIcon.addActionListener(this);
        this.btnShowStandardSystemIcon = new JButton(MENU_ITEM_SHOW_STANDARD_ICON);
        this.btnShowStandardSystemIcon.setActionCommand(MENU_ITEM_SHOW_STANDARD_ICON);
        this.btnShowStandardSystemIcon.addActionListener(this);
        this.btnShowCustomIcon = new JButton(MENU_ITEM_SHOW_CUSTOM_ICON);
        this.btnShowCustomIcon.setActionCommand(MENU_ITEM_SHOW_CUSTOM_ICON);
        this.btnShowCustomIcon.addActionListener(this);
        this.btnShowTrayBallon = new JButton(MENU_ITEM_SHOW_CALLOUT);
        this.btnShowTrayBallon.setActionCommand(MENU_ITEM_SHOW_CALLOUT);
        if (!this._isVersionOK) {
            this.btnShowTrayBallon.setEnabled(false);
        }
        this.btnShowTrayBallon.addActionListener(this);
        this.btnHideTrayIcon = new JButton(MENU_HIDE_TRAY_ICON);
        this.btnHideTrayIcon.setActionCommand(MENU_HIDE_TRAY_ICON);
        this.btnHideTrayIcon.addActionListener(this);
        Dimension buttonSize = this.btnShowStandardSystemIcon.getPreferredSize();
        this.btnShowTrayIcon.setPreferredSize(buttonSize);
        this.btnShowCustomIcon.setPreferredSize(buttonSize);
        this.btnShowTrayBallon.setPreferredSize(buttonSize);
        this.btnHideTrayIcon.setPreferredSize(buttonSize);
        this.lblNotSupported = !this._isVersionOK ? new HTMLText("<b><FONT color = red>NOTE:</FONT> Balloon tooltip feature requires 5.0 or higher version of shell32.dll module.") : new JLabel();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.btnShowTrayIcon, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.btnShowStandardSystemIcon, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.btnShowCustomIcon, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.btnShowTrayBallon, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.btnHideTrayIcon, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.lblNotSupported, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(15, 10, 0, 0), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._trayIcon = new TrayIcon(Icon.SystemIcon.BANG.getSmall());
        this._trayIcon.setToolTip("Tray Tooltip");
        this._trayIcon.addTrayListener(new TrayIconListener(){

            public void trayActionPerformed(long message, int x, int y) {
                if (message == 515L) {
                    TrayIconSample.this._trayIcon.setIcon(Icon.SystemIcon.HAND.getSmall());
                }
            }
        });
        this._popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(MENU_ITEM_SHOW_STANDARD_ICON);
        ImageIcon icon = new ImageIcon(Icon.SystemIcon.QUES.getSmall().toImage());
        BufferedImage bi = new BufferedImage(16, 16, 2);
        bi.getGraphics().drawImage(icon.getImage(), 0, 0, 16, 16, null);
        menuItem.setIcon(new ImageIcon(bi));
        menuItem.addActionListener(this);
        this._popupMenu.add(menuItem);
        menuItem = new JMenuItem(MENU_ITEM_SHOW_CUSTOM_ICON);
        icon = new ImageIcon(new Icon(TrayIconSample.class.getResourceAsStream("res/winpack.ico"), Icon.IconType.SMALL.getSize()).toImage());
        menuItem.setIcon(icon);
        menuItem.addActionListener(this);
        this._popupMenu.add(menuItem);
        this._popupMenu.addSeparator();
        icon = new ImageIcon(new BufferedImage(16, 16, 2));
        menuItem = new JMenuItem(MENU_ITEM_SHOW_CALLOUT, icon);
        if (!this._isVersionOK) {
            menuItem.setEnabled(false);
        }
        menuItem.addActionListener(this);
        this._popupMenu.add(menuItem);
        this._popupMenu.addSeparator();
        menuItem = new JMenuItem(MENU_HIDE_TRAY_ICON, icon);
        menuItem.addActionListener(this);
        this._popupMenu.add(menuItem);
        this._popupMenu.pack();
        this._trayIcon.setPopupMenu(this._popupMenu);
        VersionInfo versionInfo = new VersionInfo();
        if (versionInfo.isWin9x()) {
            this.btnShowTrayBallon.setEnabled(false);
        }
        super.initialize();
    }

    private void changeIconToQuestion() {
        this._trayIcon.setIcon(Icon.SystemIcon.QUES.getSmall());
    }

    private void changeIconToCustom() {
        try {
            Icon customIcon = new Icon(TrayIconSample.class.getResourceAsStream("res/winpack.ico"), Icon.IconType.SMALL.getSize());
            this._trayIcon.setIcon(customIcon);
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    private void showCallout() {
        this._trayIcon.showMessage((TrayMessage)new TrayMessage.Warning("Tray Balloon", "This program demonstrates the WinPack for JNIWrapper library abilities:\n\t - tray icon\n\t - menu for tray icon\n\t - balloons from tray icon\netc."));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(MENU_ITEM_SHOW_TRAY_ICON)) {
            this._trayIcon.setVisible(true);
        } else if (e.getActionCommand().equals(MENU_ITEM_SHOW_STANDARD_ICON)) {
            this.changeIconToQuestion();
        } else if (e.getActionCommand().equals(MENU_ITEM_SHOW_CUSTOM_ICON)) {
            this.changeIconToCustom();
        } else if (e.getActionCommand().equals(MENU_ITEM_SHOW_CALLOUT)) {
            this.showCallout();
        } else if (e.getActionCommand().equals(MENU_HIDE_TRAY_ICON)) {
            this._trayIcon.setVisible(false);
        }
    }

    public void deactivate() {
        this._trayIcon.setVisible(false);
    }

    public void activate() throws Exception {
        super.activate();
        this._trayIcon.setVisible(true);
    }
}

