/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.win32.com.ComFunctions;
import com.jniwrapper.win32.samples.demo.ComfyJSample;
import com.jniwrapper.win32.shell.ShellFolder;
import com.jniwrapper.win32.shell.ShellLink;
import com.jniwrapper.win32.ui.controls.SelectFileField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ShellLinksSample
extends ComfyJSample {
    private JLabel lblAdvisoryText;
    private JLabel lblCreateLinkHint;
    private JLabel lblFileNameCaption;
    private SelectFileField _selectFileField;
    private JButton btnCreateLink;
    private JLabel lblResolveLinkHint;
    private JLabel lblLinkCaption;
    private SelectFileField _selectlinkField;
    private JButton btnResolveLink;
    private JLabel lblNotSupported;

    public ShellLinksSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        boolean comfyjAvailable = this.isComfyJAvailable();
        this.lblNotSupported = comfyjAvailable ? new JLabel() : new HTMLText("<b><FONT color = red>NOTE:</FONT> The ShellLink functionality requires the ComfyJ library and ComfyJ license file.");
        this.lblAdvisoryText = new HTMLText("The page demonstrates WinPack ability to create and resolve link files.", false);
        this.lblCreateLinkHint = new HTMLText("Select a file that you want to create the link for and click \"Create link\" button. The link will be created on your desktop.", false);
        this.lblFileNameCaption = new JLabel("Select File:");
        this._selectFileField = new SelectFileField();
        this.btnCreateLink = new JButton("Create Link");
        this.btnCreateLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ShellLinksSample.this.createLink();
            }
        });
        this.lblResolveLinkHint = new HTMLText("Also, you can select a link file and press \"Resolve link\" button to see where an original file is located.", false);
        this.lblLinkCaption = new JLabel("Select Link:");
        this._selectlinkField = new SelectFileField();
        this.btnResolveLink = new JButton("Resolve Link");
        this.btnResolveLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ShellLinksSample.this.resolveLink();
            }
        });
        if (!comfyjAvailable) {
            this._selectFileField.setEnabled(false);
            this._selectlinkField.setEnabled(false);
            this.btnCreateLink.setEnabled(false);
            this.btnResolveLink.setEnabled(false);
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.lblCreateLinkHint, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.lblFileNameCaption, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this._selectFileField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.btnCreateLink, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.lblResolveLinkHint, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 2, new Insets(20, 10, 10, 10), 0, 0));
        this.add((Component)this.lblLinkCaption, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this._selectlinkField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.btnResolveLink, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.lblNotSupported, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 17, 2, new Insets(20, 10, 10, 10), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 6, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._selectFileField.getDialog().getOptions().setMultiselectionAllowed(false);
        this._selectFileField.getDialog().setFilter("All Files (*.*)|*.*");
        this._selectlinkField.getDialog().getOptions().setMultiselectionAllowed(false);
        this._selectlinkField.getDialog().setFilter("Link Files (*.lnk)|*.lnk");
        super.initialize();
    }

    private void createLink() {
        String sourceFileName = this._selectFileField.getFileName();
        if (sourceFileName.equals("")) {
            return;
        }
        File sourceFile = new File(sourceFileName);
        int index = (sourceFileName = sourceFile.getName()).lastIndexOf(46);
        if (index != -1) {
            sourceFileName = sourceFileName.substring(0, index);
        }
        sourceFileName = sourceFileName + ".lnk";
        File linkFile = new File(ShellFolder.DESKTOP.getAbsolutePath(), sourceFileName);
        ComFunctions.coInitialize();
        ShellLink.createLink((File)sourceFile, (File)linkFile, (String)"This link is created by WinPack Demo applicaion");
        ComFunctions.coUninitialize();
    }

    private void resolveLink() {
        String sourceFileName = this._selectlinkField.getFileName();
        if (sourceFileName.equals("")) {
            return;
        }
        File sourceFile = new File(sourceFileName);
        ComFunctions.coInitialize();
        String result = ShellLink.resolveLink((File)sourceFile);
        JOptionPane.showMessageDialog(this, "The choosen link file refers to the following file:\n" + result);
        ComFunctions.coUninitialize();
    }
}

