/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.BasicDemoShell;
import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LazyPanel;
import com.jniwrapper.samples.shell.components.TreeCellRenderer;
import com.jniwrapper.win32.registry.RegistryKey;
import com.jniwrapper.win32.registry.ui.RegistryKeyValuesTableModel;
import com.jniwrapper.win32.registry.ui.RegistryTreeModel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RegistryKeySample
extends LazyPanel
implements TreeSelectionListener {
    private JLabel lblAdvisoryText;
    private JTree _registry;
    private JTable _registryKeyValues;
    private RegistryKeyValuesTableModel _registryKeyValuesTableModel;
    private RegistryTreeModel _registryTreeModel;

    public RegistryKeySample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        this.lblAdvisoryText = new HTMLText("This page demonstrates a simple registry viewer created using RegistryKey class methods.");
        this._registryTreeModel = new RegistryTreeModel();
        this._registry = new JTree((TreeModel)this._registryTreeModel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void setExpandedState(TreePath path, boolean state) {
                if (state) {
                    Cursor waitCursor = Cursor.getPredefinedCursor(3);
                    Cursor defCursor = this.getCursor();
                    try {
                        this.setCursor(waitCursor);
                        super.setExpandedState(path, state);
                    }
                    finally {
                        this.setCursor(defCursor);
                    }
                } else {
                    super.setExpandedState(path, state);
                }
            }
        };
        this._registry.setRootVisible(false);
        this._registry.addTreeSelectionListener(this);
        BasicTreeUI basicTreeUI = (BasicTreeUI)this._registry.getUI();
        basicTreeUI.setCollapsedIcon(new ImageIcon(BasicDemoShell.class.getResource("res/Closed.gif")));
        basicTreeUI.setExpandedIcon(new ImageIcon(BasicDemoShell.class.getResource("res/Opened.gif")));
        this._registry.putClientProperty("JTree.lineStyle", "None");
        this._registry.setCellRenderer(new TreeCellRenderer());
        this._registry.setShowsRootHandles(true);
        this._registryKeyValuesTableModel = new RegistryKeyValuesTableModel();
        this._registryKeyValues = new JTable((TableModel)this._registryKeyValuesTableModel);
        this._registryKeyValues.setRowSelectionAllowed(true);
        this._registryKeyValues.setSelectionMode(0);
        this._registryKeyValues.setShowHorizontalLines(false);
        this._registryKeyValues.setShowVerticalLines(false);
        TableColumnModel columnModel = this._registryKeyValues.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(80);
        columnModel.getColumn(1).setPreferredWidth(70);
        columnModel.getColumn(2).setPreferredWidth(110);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        JSplitPane splitter = new JSplitPane(1, true);
        splitter.setBorder(null);
        splitter.setDividerSize(2);
        splitter.setDividerLocation(170);
        JScrollPane registry = new JScrollPane(this._registry);
        JScrollPane values = new JScrollPane(this._registryKeyValues);
        splitter.add((Component)registry, "left");
        splitter.add((Component)values, "right");
        this.add((Component)splitter, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
        super.initialize();
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        RegistryTreeModel.RegistryKeyNode node = (RegistryTreeModel.RegistryKeyNode)path.getPathComponent(path.getPathCount() - 1);
        RegistryKey key = node.getRegistryKey();
        this._registryKeyValuesTableModel.setRegistryKey(key);
        this._registryKeyValues.revalidate();
        this._registryKeyValues.repaint();
    }
}

