/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LazyPanel;
import com.jniwrapper.samples.shell.components.LineBevel;
import com.jniwrapper.win32.Point;
import com.jniwrapper.win32.hook.Hook;
import com.jniwrapper.win32.hook.HookEventListener;
import com.jniwrapper.win32.hook.HookEventObject;
import com.jniwrapper.win32.hook.KeyboardEvent;
import com.jniwrapper.win32.hook.MouseEvent;
import com.jniwrapper.win32.ui.Wnd;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HooksSample
extends LazyPanel {
    private static final String VIRTUAL_KEY_CODE_PATTERN = "Virtual Key Code = {0}, Scan Code = {1}, Extended Key = {2}";
    private static final String COORDINATES_PATTERN = "Mouse Coordinates: X={0}, Y={1}";
    private static final String HOOK_NOT_INSTALLED_MESSAGE = "Hook is not installed.";
    private static final String HOOK_INSTALLED_MESSAGE = "Hook installed successfully.";
    private JLabel lblAdvisoryText;
    private JLabel lblMouseHook;
    private JLabel lblMouseHookHint;
    private JLabel lblMouseHookData;
    private JButton _installMouseHook;
    private JButton _uninstallMouseHook;
    private Hook _mouseHook;
    private JLabel lblKeyboarHook;
    private JLabel lblKeyboarHookHint;
    private JLabel lblKeyboarHookData;
    private JButton _installKeyboardHook;
    private JButton _uninstallKeyboardHook;
    private Hook _keyboardHook;
    private boolean _activated = false;

    public HooksSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        this.lblAdvisoryText = new HTMLText("The page demonstrates the WinPack ability to install Windows Hooks, using the Hooks API.");
        this._mouseHook = Hook.MOUSE;
        this._mouseHook.addListener(new HookEventListener(){

            public void onHookEvent(HookEventObject event) {
                MouseEvent mouseEvent = (MouseEvent)event;
                Point point = mouseEvent.getPoint();
                HooksSample.this.lblMouseHookData.setText(HooksSample.this.getCoordinatesText(point.getX(), point.getY()));
            }
        });
        this._keyboardHook = Hook.KEYBOARD;
        this._keyboardHook.addListener(new HookEventListener(){

            public void onHookEvent(HookEventObject event) {
                KeyboardEvent keyboardEvent = (KeyboardEvent)event;
                HooksSample.this.lblKeyboarHookData.setText(HooksSample.this.getVirtualKeyCodeText(keyboardEvent.getVirtualKeyCode(), keyboardEvent.getScanCode(), keyboardEvent.isExtendedKey()));
            }
        });
        Dimension prefferedSize = new Dimension(80, 20);
        this.lblMouseHook = new JLabel("Mouse Hook");
        this.lblMouseHookHint = new HTMLText("This hook allows to intercept <u>all</u> mouse events.<br>Press the \"Install\" button to install the Mouse Hook and the \"Uninstall\" button to uninstall it.");
        this.lblMouseHookData = new JLabel(HOOK_NOT_INSTALLED_MESSAGE);
        this._installMouseHook = new JButton("Install");
        this._installMouseHook.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!HooksSample.this._mouseHook.isInstalled()) {
                    HooksSample.this._mouseHook.install();
                    HooksSample.this.lblMouseHookData.setText(HooksSample.HOOK_INSTALLED_MESSAGE);
                    HooksSample.this._installMouseHook.setEnabled(false);
                    HooksSample.this._uninstallMouseHook.setEnabled(true);
                }
            }
        });
        this._installMouseHook.setPreferredSize(prefferedSize);
        this._uninstallMouseHook = new JButton("Uninstall");
        this._uninstallMouseHook.setEnabled(false);
        this._uninstallMouseHook.setPreferredSize(prefferedSize);
        this._uninstallMouseHook.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HooksSample.this.uninstallMouseHook();
            }
        });
        this.lblKeyboarHook = new JLabel("Keyboard Hook");
        this.lblKeyboarHookHint = new HTMLText("This hook allows to intercept <u>all</u> keyboard events. Try typing some text in other window to see hook in action in Demo window.<br>Press the \"Install\" button to install the Keyboard Hook and the \"Uninstall\" button to uninstall it.");
        this.lblKeyboarHookData = new JLabel(HOOK_NOT_INSTALLED_MESSAGE);
        this._installKeyboardHook = new JButton("Install");
        this._installKeyboardHook.setPreferredSize(prefferedSize);
        this._installKeyboardHook.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!HooksSample.this._keyboardHook.isInstalled()) {
                    HooksSample.this._keyboardHook.install();
                    HooksSample.this.lblKeyboarHookData.setText(HooksSample.HOOK_INSTALLED_MESSAGE);
                    HooksSample.this._installKeyboardHook.setEnabled(false);
                    HooksSample.this._uninstallKeyboardHook.setEnabled(true);
                }
            }
        });
        this._uninstallKeyboardHook = new JButton("Uninstall");
        this._uninstallKeyboardHook.setEnabled(false);
        this._uninstallKeyboardHook.setPreferredSize(prefferedSize);
        this._uninstallKeyboardHook.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HooksSample.this.uninstallKeyboardHook();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                if (HooksSample.this._mouseHook.isInstalled()) {
                    HooksSample.this._mouseHook.uninstall();
                }
                if (HooksSample.this._keyboardHook.isInstalled()) {
                    HooksSample.this._keyboardHook.uninstall();
                }
            }
        }));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.lblMouseHook, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        LineBevel bevel1 = new LineBevel();
        this.add((Component)bevel1, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.lblMouseHookHint, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.lblMouseHookData, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        JPanel panel1 = new JPanel(new FlowLayout(1));
        panel1.add(this._installMouseHook);
        panel1.add(this._uninstallMouseHook);
        this.add((Component)panel1, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 10, 0), 0, 0));
        this.add((Component)this.lblKeyboarHook, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        LineBevel bevel2 = new LineBevel();
        this.add((Component)bevel2, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.lblKeyboarHookHint, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.lblKeyboarHookData, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        JPanel panel2 = new JPanel(new FlowLayout(1));
        panel2.add(this._installKeyboardHook);
        panel2.add(this._uninstallKeyboardHook);
        this.add((Component)panel2, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 10, 0), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 9, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        super.initialize();
    }

    private void uninstallKeyboardHook() {
        if (this._keyboardHook.isInstalled()) {
            this._keyboardHook.uninstall();
            this.lblKeyboarHookData.setText(HOOK_NOT_INSTALLED_MESSAGE);
            this._installKeyboardHook.setEnabled(true);
            this._uninstallKeyboardHook.setEnabled(false);
        }
    }

    private void uninstallMouseHook() {
        if (this._mouseHook.isInstalled()) {
            this._mouseHook.uninstall();
            this.lblMouseHookData.setText(HOOK_NOT_INSTALLED_MESSAGE);
            this._installMouseHook.setEnabled(true);
            this._uninstallMouseHook.setEnabled(false);
        }
    }

    public void deactivate() {
        this.uninstallMouseHook();
        this.uninstallKeyboardHook();
        if (this._activated) {
            Wnd parentWindow = new Wnd((Component)this.getParentWindow());
            parentWindow.setTopmost(false);
            this._activated = false;
        }
        super.deactivate();
    }

    private String getCoordinatesText(long x, long y) {
        return MessageFormat.format(COORDINATES_PATTERN, new Long(x), new Long(y));
    }

    private String getVirtualKeyCodeText(long code, long scanCode, boolean extendedKey) {
        return MessageFormat.format(VIRTUAL_KEY_CODE_PATTERN, new Long(code), new Long(scanCode), new Boolean(extendedKey));
    }

    public void activate() throws Exception {
        super.activate();
        Wnd parentWindow = new Wnd((Component)this.getParentWindow());
        parentWindow.setTopmost(true);
        this._activated = true;
    }
}

