/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LazyPanel;
import com.jniwrapper.samples.shell.components.LineBevel;
import com.jniwrapper.win32.dde.DdeClient;
import com.jniwrapper.win32.dde.DdeClientEventHandler;
import com.jniwrapper.win32.dde.DdeException;
import com.jniwrapper.win32.dde.DdeItem;
import com.jniwrapper.win32.dde.DdeResponse;
import com.jniwrapper.win32.dde.DdeService;
import com.jniwrapper.win32.dde.DdeServiceEventHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.Timer;

public class DdeSample
extends LazyPanel {
    private JLabel _lblAdvisoryText;
    private JLabel _lblService;
    private JLabel _lblClient;
    private JLabel _lblMessageLog;
    private JTextArea _serviceLog;
    private MyClient _myClient;
    private MyService _myService;

    public DdeSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        this._lblAdvisoryText = new HTMLText("This page demonstrates a simple DDE client-server conversation.");
        this._lblClient = new JLabel("DDE Client");
        this._lblService = new JLabel("DDE Service");
        this._serviceLog = new JTextArea();
        this._serviceLog.setFont(new Font("Courier New", 0, 12));
        this._serviceLog.setEditable(false);
        this._myService = new MyService();
        this._myClient = new MyClient();
        this._lblMessageLog = new JLabel("Message Log:");
        LineBevel bevel1 = new LineBevel();
        LineBevel bevel2 = new LineBevel();
        this.setLayout(new BorderLayout());
        JPanel clientHeader = new JPanel(new GridBagLayout());
        clientHeader.add((Component)this._lblAdvisoryText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        clientHeader.add((Component)this._lblClient, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        clientHeader.add((Component)bevel1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 10, 0, 0), 0, 0));
        this._myClient.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JSplitPane clientPane = new JSplitPane(0, clientHeader, this._myClient);
        clientPane.setBorder(BorderFactory.createEmptyBorder());
        clientPane.setDividerLocation(60);
        clientPane.setDividerSize(0);
        JPanel serviceHeader = new JPanel(new GridBagLayout());
        serviceHeader.add((Component)this._lblService, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        serviceHeader.add((Component)bevel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 10, 0, 0), 0, 0));
        JPanel servicePanel = new JPanel(new GridBagLayout());
        servicePanel.add((Component)this._lblMessageLog, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        servicePanel.add((Component)new JScrollPane(this._serviceLog), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 10, 10), 0, 0));
        JSplitPane servicePane = new JSplitPane(0, serviceHeader, servicePanel);
        servicePane.setBorder(BorderFactory.createEmptyBorder());
        servicePane.setDividerSize(0);
        final JSplitPane splitPane = new JSplitPane(0, clientPane, servicePane);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        splitPane.setDividerLocation(0.6);
        splitPane.setDividerSize(0);
        splitPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                splitPane.setDividerLocation(0.6);
            }
        });
        this.add((Component)splitPane, "Center");
        this._myService.runService();
        this.getParentWindow().addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    DdeSample.this._myService.shutdownService();
                }
                catch (DdeException ddeException) {
                    // empty catch block
                }
            }
        });
        super.initialize();
    }

    JTextArea getServiceLog() {
        return this._serviceLog;
    }

    public class MyClient
    extends JPanel {
        private DdeClient _systemClient = new DdeClient("MyService", "System");
        private DdeClient _dataClient = new DdeClient("MyService", "Data");
        private JTextArea _logArea;
        private JToggleButton _btnConnect;
        private JToggleButton _btnAdviseLoop;
        private JTextField _textField;
        private JButton _btnGetSpool;
        private JButton _btnSetSpool;
        private JButton _btnReverseSpool;
        private JLabel _lblSpoolData;
        private JLabel _lblMessageLog;
        private long _timeout = 1000L;
        private long _transactionID = 0L;

        public MyClient() {
            this._dataClient.setEventHandler((DdeClientEventHandler)new EventHandler());
            this._logArea = new JTextArea();
            this._logArea.setFont(new Font("Courier New", 0, 12));
            this._logArea.setEditable(false);
            this._btnConnect = new JToggleButton(new AbstractAction("Connect to MyService"){

                public void actionPerformed(ActionEvent e) {
                    if (MyClient.this._btnConnect.isSelected()) {
                        try {
                            MyClient.this._systemClient.connect();
                            MyClient.this._dataClient.connect();
                            MyClient.this._logArea.append("The connection to MyService is established successfully\n");
                            MyClient.this._btnConnect.setText("Disconnect from MyService");
                        }
                        catch (DdeException ex) {
                            MyClient.this._logArea.append("Unable to connect to MyService\n");
                            MyClient.this._btnConnect.setSelected(false);
                        }
                    } else {
                        try {
                            if (MyClient.this._btnAdviseLoop.isSelected()) {
                                MyClient.this._btnAdviseLoop.doClick();
                            }
                            MyClient.this._systemClient.disconnect();
                            MyClient.this._dataClient.disconnect();
                            MyClient.this._logArea.append("The client is disconnected from MyService\n");
                            MyClient.this._btnConnect.setText("Connect to MyService");
                        }
                        catch (DdeException ex) {
                            MyClient.this._logArea.append("Unable to disconnect from MyService\n");
                        }
                    }
                }
            });
            this._btnAdviseLoop = new JToggleButton(new AbstractAction("Start Advise Loop"){

                public void actionPerformed(ActionEvent e) {
                    if (MyClient.this._btnAdviseLoop.isSelected()) {
                        try {
                            MyClient.this._dataClient.startAdviseLoop(new DdeItem("Timer", 1L), true, true, MyClient.this._timeout);
                            MyClient.this._logArea.append("An advise loop is started\n");
                            MyClient.this._btnAdviseLoop.setText("Stop Advise Loop");
                        }
                        catch (DdeException ex) {
                            MyClient.this._btnAdviseLoop.setSelected(false);
                            MyClient.this._logArea.append("Unable to start an advise loop\n");
                        }
                    } else {
                        try {
                            MyClient.this._dataClient.stopAdviseLoop(new DdeItem("Timer"), MyClient.this._timeout);
                            MyClient.this._logArea.append("An advise loop is stopped\n");
                            MyClient.this._btnAdviseLoop.setText("Start Advise Loop");
                        }
                        catch (DdeException ex) {
                            MyClient.this._logArea.append("Unable to stop the advise loop\n");
                        }
                    }
                }
            });
            this._textField = new JTextField(19);
            this._btnGetSpool = new JButton(new AbstractAction("Receive"){

                public void actionPerformed(ActionEvent e) {
                    try {
                        byte[] data = MyClient.this._dataClient.get(new DdeItem("Spool"), MyClient.this._timeout);
                        MyClient.this._logArea.append("The spool data : " + new String(data) + "\n");
                    }
                    catch (DdeException ex) {
                        MyClient.this._logArea.append("Unable to receive a spool data\n");
                    }
                }
            });
            this._btnSetSpool = new JButton(new AbstractAction("Send"){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MyClient.this._dataClient.send(new DdeItem("Spool"), MyClient.this._textField.getText().getBytes(), MyClient.this._timeout);
                        MyClient.this._logArea.append("\"" + MyClient.this._textField.getText() + "\" was sent to Spool\n");
                    }
                    catch (DdeException ex) {
                        MyClient.this._logArea.append("Unable to send data to Spool\n");
                    }
                }
            });
            this._btnReverseSpool = new JButton(new AbstractAction("Reverse"){

                public void actionPerformed(ActionEvent e) {
                    try {
                        MyClient.this._dataClient.execute("Reverse", MyClient.this._timeout);
                        MyClient.this._logArea.append("The command was successfully executed\n");
                    }
                    catch (DdeException ex) {
                        MyClient.this._logArea.append("Unable to execute the command\n");
                    }
                }
            });
            Dimension buttonSize = new JButton("Disconnect from MyService").getPreferredSize();
            this._btnAdviseLoop.setPreferredSize(buttonSize);
            this._btnConnect.setPreferredSize(buttonSize);
            buttonSize = this._btnReverseSpool.getPreferredSize();
            this._btnSetSpool.setPreferredSize(buttonSize);
            this._btnGetSpool.setPreferredSize(buttonSize);
            this._lblSpoolData = new JLabel("The Spool Data: ");
            this._lblSpoolData.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel navPanel = new JPanel();
            navPanel.setLayout(new GridBagLayout());
            navPanel.add((Component)this._btnConnect, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 25), 0, 0));
            navPanel.add((Component)this._btnAdviseLoop, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 25), 0, 0));
            navPanel.add((Component)this._lblSpoolData, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            navPanel.add((Component)this._textField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            JPanel spoolNav = new JPanel(new FlowLayout());
            spoolNav.add(this._btnGetSpool);
            spoolNav.add(this._btnSetSpool);
            spoolNav.add(this._btnReverseSpool);
            spoolNav.setBorder(BorderFactory.createEmptyBorder());
            navPanel.add((Component)spoolNav, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this._lblMessageLog = new JLabel("Message Log:");
            this.setLayout(new BorderLayout());
            JPanel logPanel = new JPanel(new GridBagLayout());
            logPanel.add((Component)this._lblMessageLog, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            logPanel.add((Component)new JScrollPane(this._logArea), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            JPanel navWrapper = new JPanel(new BorderLayout());
            navWrapper.add((Component)navPanel, "West");
            JSplitPane splitPane = new JSplitPane(0, navWrapper, logPanel);
            splitPane.setBorder(BorderFactory.createEmptyBorder());
            splitPane.setDividerSize(0);
            this.add((Component)splitPane, "Center");
        }

        private class EventHandler
        implements DdeClientEventHandler {
            private EventHandler() {
            }

            public void error(int errorCode) {
                MyClient.this._logArea.append("Error message : error code " + new Integer(errorCode) + "\n");
            }

            public DdeResponse itemChanged(DdeItem item, byte[] data) {
                MyClient.this._logArea.append("Advise loop message : \nMyService was started " + new String(data) + " seconds ago [item=" + item.getName() + ";format=" + item.getFormat() + "]\n");
                return DdeResponse.PROCESSED;
            }

            public void asyncActionComplete(DdeItem item, byte[] data, long transactionID) {
                if (transactionID == MyClient.this._transactionID) {
                    MyClient.this._logArea.append("\nCurrent date [asynchronous action complete] : \n\t" + new String(data) + "\n");
                }
            }

            public void disconnect(boolean sameApplication) {
                MyClient.this._logArea.append("MyService is disconnected\n");
            }

            public void serviceRegister(String service, String instanceName) {
            }

            public void serviceUnregister(String service, String instanceName) {
            }
        }
    }

    public class MyService {
        private String _currentDate;
        private StringBuffer _spool = new StringBuffer();
        private int _timer = 0;
        private DdeService _service;

        private void log(String s) {
            DdeSample.this._serviceLog.append(s + "\n");
        }

        public void runService() throws DdeException {
            this._service = new DdeService("MyService");
            EventHandler eventHandler = new EventHandler();
            this._service.setEventHandler((DdeServiceEventHandler)eventHandler);
            this._service.register();
            this.log("Service \"MyService\" is running...");
        }

        public void shutdownService() throws DdeException {
            this._service.unregister();
            this.log("Service \"MyService\" is stopped.");
        }

        private class EventHandler
        implements DdeServiceEventHandler {
            public EventHandler() {
                Date date = new Date();
                MyService.this._currentDate = date.toString();
                new Timer(1000, new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        MyService.this._timer++;
                        if (MyService.this._service != null && MyService.this._service.isRegistered()) {
                            try {
                                MyService.this._service.postAdvise("Data", "Timer");
                            }
                            catch (DdeException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }).start();
            }

            public byte[] adviseRequest(String topic, DdeItem item) {
                if (!topic.equalsIgnoreCase("Data") | !item.getName().equalsIgnoreCase("Timer") | item.getFormat() != 1L) {
                    return null;
                }
                String result = new Integer(MyService.this._timer).toString();
                MyService.this.log("Advise request : " + result);
                return result.getBytes();
            }

            public boolean adviseStart(String topic, DdeItem item) {
                if (!topic.equalsIgnoreCase("Data") | !item.getName().equalsIgnoreCase("Timer") | item.getFormat() != 1L) {
                    MyService.this.log("Advise start : refused");
                    return false;
                }
                MyService.this.log("Advise start : confirmed");
                return true;
            }

            public void adviseStop(String topic, DdeItem item) {
                MyService.this.log("Advise stoped");
            }

            public DdeResponse execute(String topic, String command) {
                if (!topic.equalsIgnoreCase("Data") | !command.equalsIgnoreCase("reverse")) {
                    MyService.this.log("Execute [" + topic + ", " + command + "] : Not processed");
                    return DdeResponse.NOTPROCESSED;
                }
                MyService.this._spool = MyService.this._spool.reverse();
                MyService.this.log("Execute [" + topic + ", " + command + "] : Processed");
                return DdeResponse.PROCESSED;
            }

            public boolean beforeConnect(String topic, boolean sameApplication) {
                if (!topic.equalsIgnoreCase("System") && !topic.equalsIgnoreCase("Data")) {
                    if (sameApplication) {
                        MyService.this.log("Connection to " + topic + " topic has been refused (the same application)");
                    } else {
                        MyService.this.log("Connection to " + topic + " topic has been refused");
                    }
                    return false;
                }
                if (sameApplication) {
                    MyService.this.log("Connection to " + topic + " topic has been " + "established (the same application)");
                } else {
                    MyService.this.log("Connection to " + topic + " has been established");
                }
                return true;
            }

            public DdeResponse pokeData(String topic, DdeItem item, byte[] data) {
                if (!topic.equalsIgnoreCase("Data") | !item.getName().equalsIgnoreCase("Spool") | item.getFormat() != 1L) {
                    MyService.this.log("Poke data [" + new String(data) + "] : Not processed");
                    return DdeResponse.NOTPROCESSED;
                }
                MyService.this._spool = new StringBuffer(new String(data));
                MyService.this.log("Poke data [" + new String(data) + "] : Processed");
                return DdeResponse.PROCESSED;
            }

            public byte[] requestData(String topic, DdeItem item) {
                if (topic.equalsIgnoreCase("System")) {
                    if (item.getName().equalsIgnoreCase("Topics")) {
                        String result = "System\tData";
                        MyService.this.log("Request data [" + topic + ", " + item.getName() + "] : " + result);
                        return result.getBytes();
                    }
                    if (item.getName().equalsIgnoreCase("Items")) {
                        String result = "CurrentDate\tSpool\tTimer";
                        MyService.this.log("Request data [" + topic + ", " + item.getName() + "] : " + result);
                        return result.getBytes();
                    }
                    if (item.getName().equalsIgnoreCase("Formats")) {
                        String result = "CF_TEXT";
                        MyService.this.log("Request data [" + topic + ", " + item.getName() + "] : " + result);
                        return result.getBytes();
                    }
                    if (item.getName().equalsIgnoreCase("SysItems")) {
                        String result = "Topics\tItems\tFormats\tSysItems";
                        MyService.this.log("Request data [" + topic + ", " + item.getName() + "] : " + result);
                        return result.getBytes();
                    }
                    MyService.this.log("Request data : item \"" + item.getName() + "\" is not supported by System topic");
                    return null;
                }
                if (topic.equalsIgnoreCase("Data")) {
                    if (item.getName().equalsIgnoreCase("CurrentDate")) {
                        MyService.this.log("Request data [" + topic + ", " + item.getName() + "] : " + MyService.this._currentDate);
                        return MyService.this._currentDate.getBytes();
                    }
                    if (item.getName().equalsIgnoreCase("Spool")) {
                        MyService.this.log("Request data [" + topic + ", " + item.getName() + "] : " + MyService.this._spool.toString());
                        return MyService.this._spool.toString().getBytes();
                    }
                    if (item.getName().equalsIgnoreCase("Timer")) {
                        String result = new Integer(MyService.this._timer).toString();
                        MyService.this.log("Request data [" + topic + ", " + item.getName() + "] : " + result);
                        return result.getBytes();
                    }
                    MyService.this.log("Request data : item \"" + item.getName() + "\" is not supported by Data topic");
                    return null;
                }
                MyService.this.log("Request data : topic \"" + topic + "\" is not supported");
                return null;
            }

            public void disconnect(boolean sameApplication) {
                if (sameApplication) {
                    MyService.this.log("Disconnected (the same application)");
                } else {
                    MyService.this.log("Disconnected");
                }
            }

            public void serviceRegister(String service, String instanceName) {
                MyService.this.log("A service registered : " + instanceName);
            }

            public void serviceUnregister(String service, String instanceName) {
                MyService.this.log("A service unregistered : " + instanceName);
            }
        }
    }
}

