/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.gdi.Region;
import com.jniwrapper.win32.ui.Wnd;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JWindow;

class CustomShapeWindow
extends JWindow
implements MouseMotionListener {
    private int _mouseX = 0;
    private int _mouseY = 0;
    private Region _windowShape;
    private ImageIcon _image;

    public CustomShapeWindow(Window owner) {
        super(owner);
        this.init();
    }

    private void init() {
        JPanel newContentPane = new JPanel(){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                CustomShapeWindow.this._image.paintIcon(CustomShapeWindow.this.getContentPane(), g, 0, 0);
            }
        };
        newContentPane.setOpaque(true);
        this.setContentPane(newContentPane);
        this.addMouseMotionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                CustomShapeWindow.this.applyWindowRegion();
            }
        });
    }

    private void applyWindowRegion() {
        Wnd wnd = new Wnd((Component)this);
        wnd.setRegion(this.getWindowShape(), true);
    }

    public void setWindowShape(Region value) {
        this._windowShape = value;
        this.setSize(this._image.getIconWidth(), this._image.getIconHeight());
        this.validate();
        this.applyWindowRegion();
    }

    public Region getWindowShape() {
        if (this._windowShape == null) {
            throw new IllegalStateException("Custom shape is not assigned.");
        }
        return this._windowShape;
    }

    public ImageIcon getImage() {
        return this._image;
    }

    public void setImage(ImageIcon image) {
        this._image = image;
    }

    public void mouseMoved(MouseEvent e) {
        this._mouseX = e.getX();
        this._mouseY = e.getY();
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int dx = x - this._mouseX;
        int dy = y - this._mouseY;
        this.setLocation(this.getX() + dx, this.getY() + dy);
    }
}

