/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.samples.shell.components.HTMLText;
import com.jniwrapper.samples.shell.components.LazyPanel;
import com.jniwrapper.win32.ui.controls.ChooseColorField;
import com.jniwrapper.win32.ui.dialogs.ChooseColorDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;

public class ChooseColorSample
extends LazyPanel
implements PropertyChangeListener {
    private JLabel lblAdvisoryText;
    private JLabel lblSelectedColor;
    private JLabel lblCustomColors;
    private ChooseColorField _colorField;
    private ColorsPanel _customColors;
    private JLabel lblNote;

    public ChooseColorSample(Window parent) {
        super(parent);
    }

    public void initialize() throws Exception {
        this.lblAdvisoryText = new HTMLText("This page demonstrates a standard system color-selection dialog box which is invoked using a special ChooseColorField control.");
        this.lblSelectedColor = new JLabel("Select Color:");
        this.lblCustomColors = new JLabel("Custom Colors:");
        this._colorField = new ChooseColorField(Color.yellow);
        this._colorField.addPropertyChangeListener("color", (PropertyChangeListener)this);
        this._customColors = new ColorsPanel();
        this.lblNote = new HTMLText("<b>NOTE:</b> Using the dialog box, fill the Custom Colors area in it to see the selected colors above.");
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblAdvisoryText, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.lblSelectedColor, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this._colorField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.lblCustomColors, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this._customColors, new GridBagConstraints(1, 2, 1, 2, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.lblNote, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        ChooseColorDialog dialog = this._colorField.getDialog();
        dialog.setColor(Color.yellow);
        List customColors = dialog.getCustomColors();
        for (int i = 0; i < 16; ++i) {
            customColors.add(Color.white);
        }
        dialog.getOptions().setFullOpen(true);
        this._customColors.setCustomColors(customColors);
        this.updateUI();
        super.initialize();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this._customColors.setCustomColors(this._colorField.getDialog().getCustomColors());
    }

    class ColorsPanel
    extends JPanel {
        private static final int MAX_COLORS = 16;

        public ColorsPanel() {
            this.setLayout(new GridLayout(2, 8));
            for (int i = 0; i < 16; ++i) {
                JPanel panel = new JPanel();
                Dimension size = new Dimension(20, 20);
                panel.setPreferredSize(size);
                panel.setMinimumSize(size);
                panel.setMaximumSize(size);
                panel.setBackground(Color.black);
                panel.setBorder(new BevelBorder(1));
                this.add((Component)panel, i);
            }
            this.setBorder(new LineBorder(Color.gray));
            this.updateUI();
        }

        void setCustomColors(List colors) {
            int colorsCount = Math.min(16, colors.size());
            for (int i = 0; i < colorsCount; ++i) {
                Component component = this.getComponent(i);
                Color color = (Color)colors.get(i);
                component.setBackground(color);
            }
            this.updateUI();
        }
    }
}

