/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples;

import com.jniwrapper.Callback;
import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.gdi.Brush;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.system.Module;
import com.jniwrapper.win32.system.VersionInfo;
import com.jniwrapper.win32.ui.PaintStruct;
import com.jniwrapper.win32.ui.WindowProc;
import com.jniwrapper.win32.ui.Wnd;
import com.jniwrapper.win32.ui.WndClass;

public class TransparentNativeWindow {
    private static WndClass _wndClass;
    private Wnd _hWnd;
    private static boolean _isWin2k;

    public TransparentNativeWindow() {
        this(10L, 10L, 400L, 200L);
    }

    public TransparentNativeWindow(long x, long y, long width, long height) {
        VersionInfo versionInfo = new VersionInfo();
        int extStyle = 0xCF0000;
        int style = 776;
        String caption = "Transparent Native Dialog";
        if (versionInfo.isWin9x()) {
            extStyle = 0;
            caption = "Native Dialog";
        } else if (versionInfo.isWin2k()) {
            style |= 0x80000;
            _isWin2k = true;
        }
        Module hModule = Module.getCurrent();
        Wnd nullParent = new Wnd();
        Handle NULL = new Handle();
        this._hWnd = Wnd.createWindow((int)style, (String)this.getClass().getName(), (String)caption, (int)extStyle, (long)x, (long)y, (long)width, (long)height, (Wnd)nullParent, (Handle)NULL, (Handle)hModule, (Handle)NULL);
    }

    public void run() {
        this._hWnd.show(Wnd.ShowWindowCommand.SHOW);
        if (_isWin2k) {
            this._hWnd.setTransparency((byte)-106);
            this._hWnd.setPalleteWindow(true);
        }
        this._hWnd.eventLoop();
    }

    public static void main(String[] args) {
        TransparentNativeWindow window = new TransparentNativeWindow();
        window.run();
    }

    static {
        DefaultLibraryLoader.getInstance().addPath("bin");
        String windowClassName = TransparentNativeWindow.class.getName();
        _wndClass = new WndClass((Callback)new TransparentWindowProc(), windowClassName);
        _wndClass.setBackground((Handle)new Brush(Brush.BrushStyle.NULL));
        _wndClass.register();
    }

    private static class TransparentWindowProc
    extends WindowProc {
        private TransparentWindowProc() {
        }

        public void callback() {
            int message = (int)this._msg.getValue();
            switch (message) {
                case 15: {
                    Rect updateRect = new Rect();
                    if (!this._wnd.getUpdateRect(updateRect)) break;
                    PaintStruct paintStruct = new PaintStruct();
                    DC hDC = this._wnd.beginPaint(paintStruct);
                    if (_isWin2k) {
                        hDC.textOut(10, 10, "This sample demonstrates a native window");
                        hDC.textOut(10, 30, "with an applied tool window style,");
                        hDC.textOut(10, 50, "transparency and topmost position.");
                    } else {
                        hDC.textOut(10, 10, "This sample demonstrates a native window");
                        hDC.textOut(10, 30, "with topmost position.");
                    }
                    this._wnd.endPaint(paintStruct);
                    this._lResult.setValue(0L);
                    break;
                }
                default: {
                    super.callback();
                }
            }
        }
    }
}

