/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.samples.shell.components;

import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TreeCellRenderer
extends DefaultTreeCellRenderer {
    private static ImageIcon FOLDER_ICON = new ImageIcon(TreeCellRenderer.class.getResource("res/FolderClosed.png"));
    private static ImageIcon FOLDER_OPEN_ICON = new ImageIcon(TreeCellRenderer.class.getResource("res/FolderOpened.png"));
    private static ImageIcon LEAF_ICON = new ImageIcon(TreeCellRenderer.class.getResource("res/Leaf.gif"));

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (!leaf) {
            if (expanded) {
                this.setIcon(FOLDER_OPEN_ICON);
            } else {
                this.setIcon(FOLDER_ICON);
            }
        } else {
            ImageIcon icon = null;
            try {
                Method getIconMethod = value.getClass().getDeclaredMethod("getIcon", null);
                getIconMethod.setAccessible(true);
                icon = (ImageIcon)getIconMethod.invoke(value, null);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.setIcon(icon == null ? LEAF_ICON : icon);
        }
        return this;
    }
}

