/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.samples.shell;

import com.jniwrapper.samples.shell.XMLDOMHelper;
import org.w3c.dom.Node;

class Sample {
    private XMLDOMHelper _xmlHelper;
    private Node _sampleNode;

    public Sample(Node sampleNode) {
        if (sampleNode == null) {
            throw new IllegalArgumentException("sampleNode parameter is null.");
        }
        this._sampleNode = sampleNode;
        this._xmlHelper = new XMLDOMHelper();
    }

    public String getName() {
        return this._xmlHelper.getValueByName(this._sampleNode, "Name");
    }

    public String getIconType() {
        return this._xmlHelper.getValueByName(this._sampleNode, "IconType");
    }

    public boolean isStandardIcon() {
        return this.getIconType().equalsIgnoreCase("Standard");
    }

    public boolean isNewIcon() {
        return this.getIconType().equalsIgnoreCase("New");
    }

    public boolean isUpdateIcon() {
        return this.getIconType().equalsIgnoreCase("Update");
    }

    public boolean isCustomIcon() {
        return this.getIconType().equalsIgnoreCase("Custom");
    }

    public String getIconPath() {
        return this._xmlHelper.getValueByName(this._sampleNode, "IconPath");
    }

    public Class getSampleClass() throws ClassNotFoundException {
        String sampleClass = this._xmlHelper.getValueByName(this._sampleNode, "SampleClass");
        Class<?> res = Class.forName(sampleClass);
        return res;
    }

    public Class getInitParameterClass() {
        Class<?> result;
        String initParameter = this._xmlHelper.getValueByName(this._sampleNode, "InitParameterClass");
        if (initParameter == null) {
            return null;
        }
        try {
            result = Class.forName(initParameter);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return result;
    }

    public boolean getShowSources() {
        return this._xmlHelper.getValueByName(this._sampleNode, "ShowSources") != null;
    }
}

